<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');


header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Read JSON input
$requestData = json_decode(file_get_contents("php://input"), true);

// Debugging: Check incoming request
file_put_contents("debug_api.txt", json_encode($requestData));

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);

if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Get user ID from JSON input
$user_id_ = $requestData['id'] ?? '';
$user_id = decryptData($user_id_);

if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

// Fetch user's verification status from database
$sql = "SELECT Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $verification_status = $row['Veryfi_Status'];

    if ($verification_status == 1) {
        echo json_encode(['status' => 'success', 'message' => 'User is verified']);
    } else {
        echo json_encode(['status' => 'success', 'message' => 'User is not verified']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}

$conn->close();
?>