<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

// Set Content-Type to JSON
header('Content-Type: application/json');

// Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(["status" => "error", "message" => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Proceed if API key is valid
$phone = $_POST['gmail'] ?? '';
$otp   = $_POST['otp'] ?? '';

// Decrypt Data from request
$decryptedEmail = decryptData($phone);
$decryptedOtp   = decryptData($otp);

// Validate Gmail and OTP
if (empty($decryptedEmail) || empty($decryptedOtp)) {
    echo json_encode(["status" => "error", "message" => "Invalid Gmail or OTP."]);
    $conn->close();
    exit();
}

// Query to check if Gmail and OTP match in the database
$sql = "SELECT * FROM otp_table WHERE Gmail = ? AND OTP = ? AND Expire_time > NOW()";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Failed to prepare statement: " . $conn->error]);
    $conn->close();
    exit();
}

$stmt->bind_param("ss", $decryptedEmail, $decryptedOtp);
$stmt->execute();
$result = $stmt->get_result();

// Check if OTP is valid
if ($result->num_rows > 0) {
    // OTP verified, now retrieve PIN from User_Database
    $passwordQuery = "SELECT Email, PIN FROM USER_DATABSE_PIN";
    $stmtPassword = $conn->prepare($passwordQuery);

    if (!$stmtPassword) {
        echo json_encode(["status" => "error", "message" => "Failed to prepare password query: " . $conn->error]);
        $conn->close();
        exit();
    }

    $stmtPassword->execute();
    $resultPassword = $stmtPassword->get_result();
    $stmtPassword->close();

    $found = false;
    while ($row = $resultPassword->fetch_assoc()) {
        // 🔑 Decrypt stored Email and PIN
        $storedEmail = decryptSensitive($row['Email']);
        $storedPin   = decryptSensitive($row['PIN']);

        if ($storedEmail === $decryptedEmail) {
            $found = true;
            error_log("Decrypted PIN Retrieved: " . $storedPin); // Debugging log
            echo json_encode([
                "status"  => "success",
                "message" => "OTP verified successfully.",
                "PIN"     => $storedPin
            ]);
            break;
        }
    }

    if (!$found) {
        echo json_encode(["status" => "error", "message" => "No PIN found for this email."]);
    }

} else {
    echo json_encode(["status" => "error", "message" => "Invalid OTP or expired."]);
}

// Close connections
$stmt->close();
$conn->close();
?>