<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');

// Validate API Key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(["status" => "error", "message" => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

$encryptedEmail = $_POST['gmail'] ?? '';
$encryptedOtp   = $_POST['otp'] ?? '';

// Decrypt incoming Email + OTP
$decryptedEmail = decryptData($encryptedEmail);
$decryptedOtp   = decryptData($encryptedOtp);

if (empty($decryptedEmail) || empty($decryptedOtp)) {
    echo json_encode(["status" => "error", "message" => "Invalid email or OTP"]);
    $conn->close();
    exit();
}

// OTP Check
$sql = "SELECT * FROM otp_table WHERE Gmail = ? AND OTP = ? AND Expire_time > NOW()";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $decryptedEmail, $decryptedOtp);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Invalid or expired OTP"]);
    $stmt->close();
    $conn->close();
    exit();
}

/*
|--------------------------------------------------------------------------
| STEP 1: FIND MATCHING EMAIL IN DATABASE (Email encrypted)
|--------------------------------------------------------------------------
*/
$findEmailSQL = "SELECT id, Email, User_Password FROM USER_DATABSE_PIN";
$resultEmail = $conn->query($findEmailSQL);

$matchedPasswordEncrypted = null;

while ($row = $resultEmail->fetch_assoc()) {

    $dbEncryptedEmail = $row['Email'];
    $dbDecryptedEmail = decryptSensitive($dbEncryptedEmail);

    if ($dbDecryptedEmail === $decryptedEmail) {
        // Email matched → store encrypted password
        $matchedPasswordEncrypted = $row['User_Password'];
        break;
    }
}

// If no email matched
if ($matchedPasswordEncrypted === null) {
    echo json_encode(["status" => "error", "message" => "No email found"]);
    $conn->close();
    exit();
}

/*
|--------------------------------------------------------------------------
| STEP 2: DECRYPT THE PASSWORD (stored encrypted)
|--------------------------------------------------------------------------
*/
$decryptedPassword = decryptSensitive($matchedPasswordEncrypted);

if (empty($decryptedPassword)) {
    echo json_encode(["status" => "error", "message" => "Password decryption failed"]);
    $conn->close();
    exit();
}

echo json_encode([
    "status" => "success",
    "message" => "OTP verified",
    "User_Password" => $decryptedPassword
]);

$stmt->close();
$conn->close();
?>
