<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';

// Set Content-Type to JSON
header('Content-Type: application/json');

// Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);

if (!$apiKeyValidation['status']) {
    echo json_encode(["status" => "error", "message" => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Proceed if API key is valid
$phone = $_POST['phone'] ?? '';
$otp = $_POST['otp'] ?? '';

// Decrypt Data
$decryptedPhone = decryptData($phone);
$decryptedOtp = decryptData($otp);

// Validate phone number and OTP
if (empty($decryptedPhone) || empty($decryptedOtp)) {
    echo json_encode(["status" => "error", "message" => "Invalid phone number or OTP."]);
    $conn->close();
    exit();
}

// Query to check if the phone and OTP match in the database
$sql = "SELECT * FROM otp_table WHERE Gmail = ? AND OTP = ? AND Expire_time > NOW()";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "Failed to prepare statement: " . $conn->error]);
    $conn->close();
    exit();
}

$stmt->bind_param("ss", $decryptedPhone, $decryptedOtp); // "ss" means two string parameters
$stmt->execute();
$result = $stmt->get_result();

// Check if a matching record is found
if ($result->num_rows > 0) {
    echo json_encode(["status" => "success", "message" => "OTP verified successfully."]);
} else {
    echo json_encode(["status" => "error", "message" => "Invalid OTP or expired."]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>