<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Validate API Key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Decrypt User ID
$encrypted_user_id = $requestData['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Validate Images
$selfie_photo = $requestData['Selfi_photo'] ?? '';
$nid_front = $requestData['Nid_Front'] ?? '';
$nid_back = $requestData['Nid_Back'] ?? '';

if (empty($selfie_photo) || empty($nid_front) || empty($nid_back)) {
    echo json_encode(['status' => 'error', 'message' => 'All images are required']);
    $conn->close();
    exit();
}

// Function to save Base64 image to file
function saveImage($base64Data, $prefix, $userId) {
    $folderPath = 'uploads/';
    $date = date("d_m_y_h_i_sa");
    $fileName = "{$prefix}_id_{$userId}_DT_{$date}.jpg";
    $filePath = $folderPath . $fileName;

    $imageData = base64_decode($base64Data);
    if (file_put_contents($filePath, $imageData)) {
        return "https://shop.probashpay.com/PIN_SHOP/" . $filePath;
    }
    return false;
}

// Save images
$selfieUrl = saveImage($selfie_photo, 'selfi', $user_id);
$frontNidUrl = saveImage($nid_front, 'nid_front', $user_id);
$backNidUrl = saveImage($nid_back, 'nid_back', $user_id);

if (!$selfieUrl || !$frontNidUrl || !$backNidUrl) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save images']);
    $conn->close();
    exit();
}

// Check if user already submitted and status is not 'Cancel'
$checkSql = "SELECT Status FROM NID_Verify_Request WHERE User_ID = ? ORDER BY ID DESC LIMIT 1";
$checkStmt = $conn->prepare($checkSql);
$checkStmt->bind_param("s", $user_id);
$checkStmt->execute();
$checkStmt->store_result();

if ($checkStmt->num_rows > 0) {
    $checkStmt->bind_result($existingStatus);
    $checkStmt->fetch();

    if (strtolower($existingStatus) !== 'cancel') {
        echo json_encode(['status' => 'success', 'message' => 'Already submitted successfully. Please wait for approval.']);
        $checkStmt->close();
        $conn->close();
        exit();
    }
}
$checkStmt->close();


// Update DB with image URLs
$sql = "INSERT INTO NID_Verify_Request (User_ID, Selfi, Front_NID, Back_NID, Status, Date) VALUES (?, ?, ?, ?, ?, ?)";

$status = "Pending";
$current_date = date("Y-m-d H:i:s");

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

// Bind all 6 string parameters
$stmt->bind_param("ssssss", $user_id, $selfieUrl, $frontNidUrl, $backNidUrl, $status, $current_date);


if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Images uploaded successfully']);
      // ðŸ”” Notify all admins via FCM
require 'get-access-token.php';

try {
    $adminTokenSql = "SELECT FCM_Token FROM Admin_Login WHERE LENGTH(FCM_Token) > 100";
    $adminTokenResult = $conn->query($adminTokenSql);

    if ($adminTokenResult->num_rows > 0) {
        $accessToken = getAccessToken('service-account-file.json');

        $title = "NID Request Arrive ";
        $body = "NID Request Arive ";

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        while ($adminRow = $adminTokenResult->fetch_assoc()) {
            $fcm_token = $adminRow['FCM_Token'];

            

                    $payload = json_encode([
    'message' => [
        'token' => $fcm_token,
        'data' => [
            'title' => $title,
            'body' => $body,
            'type' => 'caling_card'
        ]
    ]
]);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $fcmResponse = curl_exec($ch);
            if ($fcmResponse === FALSE) {
                error_log("FCM Send Error: " . curl_error($ch));
            } else {
                error_log("FCM Response: " . $fcmResponse);
            }

            curl_close($ch);
        }
    }
} catch (Exception $e) {
    error_log("FCM Notification Error: " . $e->getMessage());
}
} else {
    echo json_encode(['status' => 'error', 'message' => 'Database update failed']);
}

$stmt->close();
$conn->close();
?>
