<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Parse incoming JSON
$requestData = json_decode(file_get_contents("php://input"), true);

// Validate JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Validate API Key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Decrypt User ID
$encrypted_user_id = $requestData['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Get image data
$selfie_photo = $requestData['Selfi_photo'] ?? '';
if (empty($selfie_photo)) {
    echo json_encode(['status' => 'error', 'message' => 'Selfie photo is required']);
    $conn->close();
    exit();
}

// Function to save image
function saveImage($base64Data, $prefix, $userId) {
    $folderPath = 'uploads/';
    if (!file_exists($folderPath)) {
        mkdir($folderPath, 0777, true); // Create folder if it doesn't exist
    }

    $date = date("d_m_y_h_i_sa");
    $fileName = "{$prefix}_id_{$userId}_DT_{$date}.jpg";
    $filePath = $folderPath . $fileName;

    $imageData = base64_decode($base64Data);
    if (file_put_contents($filePath, $imageData)) {
        return "https://shop.probashpay.com/PIN_SHOP/" . $filePath;
    }
    return false;
}

// Save the selfie image
$selfieUrl = saveImage($selfie_photo, 'selfi', $user_id);
if (!$selfieUrl) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to save image']);
    $conn->close();
    exit();
}

// Update database
$sql = "UPDATE USER_DATABSE_PIN SET Selfi_photo = ? WHERE id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(['status' => 'error', 'message' => 'Database prepare failed']);
    $conn->close();
    exit();
}

$stmt->bind_param("ss", $selfieUrl, $user_id);
if ($stmt->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Update Profile successfully',
        'image_url' => $selfieUrl
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Profile update failed'
    ]);
}

$stmt->close();
$conn->close();
?>
