<?php
// Enable error reporting (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set content type to ensure proper JSON response
header('Content-Type: application/json; charset=utf-8');

// Include required files
include 'connection.php';
include 'decryption_api_key.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/PHPMailer/src/PHPMailer.php';
require __DIR__ . '/PHPMailer/src/SMTP.php';
require __DIR__ . '/PHPMailer/src/Exception.php';

// Set timezone
date_default_timezone_set('Asia/Dhaka');

// Read JSON input correctly
$rawInput = file_get_contents("php://input");
error_log("Raw JSON Input: " . $rawInput); // Log received JSON for debugging
$requestData = json_decode($rawInput, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Get user's IP address
$user_ip = $_SERVER['REMOTE_ADDR'];

// Get POST data
$encryptedEmail = $requestData['email'] ?? null;
$encryptedOtp = $requestData['otp'] ?? null;

$email = decryptData($encryptedEmail);
$otp = decryptData($encryptedOtp);

if (empty($email) || empty($otp)) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized request or invalid email or OTP']);
    exit();
}

// Current date and time
$current_date = date("Y-m-d");
$current_time = date("Y-m-d H:i:s");
$expire_time = date("Y-m-d H:i:s", strtotime("+2 minutes", strtotime($current_time)));

// Check daily limit of OTP requests by IP and date
$checkCountSql = "SELECT COUNT(*) AS request_count FROM otp_table WHERE User_IP = ? AND DATE(Request_Time) = ?";
$checkCountStmt = $conn->prepare($checkCountSql);
$checkCountStmt->bind_param("ss", $user_ip, $current_date);
$checkCountStmt->execute();
$countResult = $checkCountStmt->get_result();
$countRow = $countResult->fetch_assoc();
$request_count = $countRow['request_count'] ?? 0;

if ($request_count >= 10) {
    echo json_encode(['status' => 'error', 'message' => 'Today OTP send request limit is over. Please come back tomorrow.']);
    exit();
}

// Insert OTP record into database
$insertSql = "INSERT INTO otp_table (Gmail, OTP, Expire_time, Request_Time, User_IP) VALUES (?, ?, ?, ?, ?)";
$insertStmt = $conn->prepare($insertSql);
$insertStmt->bind_param("sssss", $email, $otp, $expire_time, $current_time, $user_ip);

if ($insertStmt->execute()) {
    // Send OTP via PHPMailer
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'shop.probashpay.com';           // Your SMTP server
        $mail->SMTPAuth   = true;
        $mail->Username   = 'pinshop@shop.probashpay.com'; // SMTP username
        $mail->Password   = 'dC&8};f6!f^=';               // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;  // Encryption type
        $mail->Port       = 465;

        $mail->setFrom('pinshop@shop.probashpay.com', 'PIN Shop');
        $mail->addAddress($email); // Send to user's email

        $mail->isHTML(true);
        $mail->Subject = 'Your PTC-Telecom $ PIN Shop OTP Code';
        $mail->Body    = "<div style='font-family: Arial, sans-serif; text-align:center; padding:15px; border:1px solid #ddd; border-radius:8px;'>
    <p>
        <img src='https://5gpinshop.com/images/probashi_logo_3.png?text=Probashi+Pay' 
             alt='Company Logo' 
             style='margin-bottom:20px; max-width:180px;'>
    </p>
    
    <h2 style='color:#333;'>Your OTP Code</h2>
    <p>Thanks for using <b>PTC-Telecom $ PIN Shop</b>. Please use the following OTP to continue:</p>
    
    <p style='font-size:20px; font-weight:bold; color:#2d89ef; margin:15px 0;'>$otp</p>
    
    <p style='color:#555;'>⚠️ This OTP is valid for <b>2 minutes</b>.</p>
    
    <hr style='margin:20px 0;'>
    
    <p style='font-size:14px; color:#e53935; text-align:left;'>
        🔒 <b>Security Advice:</b><br>
        • Do <b>not share</b> your OTP, password, or PIN with anyone.<br>
        • <b>PTC-Telecom $ PIN Shop staff will never ask</b> for your OTP.<br>
        • If you did not request this OTP, <b>ignore this email immediately</b>.<br>
    </p>
    
    <p style='font-size:14px; color:#333; text-align:left; margin-top:15px;'>
        📞 <b>Need Help?</b><br>
        If you have any questions about this OTP or your account, please contact our support team 
        using the <b>Support option inside the PTC-Telecom $ PIN Shop</b>.  
        <br><span style='color:#e53935;'>⚠️ Do not reply to this email or call unknown numbers about OTP issues.</span>
    </p>
    
    <p style='font-size:12px; color:#888; margin-top:20px;'>
        © 2025 PTC | Secure Money Transfer App
    </p>
</div>
";

        $mail->send();
        if ($mail->send()) {
    echo json_encode(['status' => 'success', 'message' => 'OTP sent successfully via email!']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Mail server rejected the email']);
}

    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'OTP saved but email could not be sent. Mailer Error: ' . $mail->ErrorInfo]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to store OTP in database']);
}


$insertStmt->close();
$conn->close();
?>
