<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Read JSON input
$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);

if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Get user ID from JSON input and decrypt it
$encrypted_user_id = $requestData['id'] ?? '';

if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Encrypted User ID is required']);
    exit();
}

// Decrypt user ID
$user_id = decryptData($encrypted_user_id);

if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID']);
    exit();
}

// Fetch user's data from database
$sql = "SELECT Frist_Name, Last_Name, Phone_Number, Balance, Joining_date, My_Reffer_Code, Reward, Total_Deposit, Total_Spend 
        FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    
    // Decrypt sensitive data
    $decrypted_phone   = decryptSensitive($row['Phone_Number']);
    $decrypted_balance = decryptSensitive($row['Balance']);
    $decrypted_reward  = decryptSensitive($row['Reward']);
    
    // Return user data as JSON
    echo json_encode([
        'status' => 'success',
        'message' => 'User data retrieved successfully',
        'data' => [
            'Phone_Number' => $decrypted_phone,
            'Frist_Name'   => $row['Frist_Name'],
            'Last_Name'    => $row['Last_Name'],
            'Balance'      => number_format((float)$decrypted_balance, 2, '.', ''),
            'Joining_date' => $row['Joining_date'],
            'Reward'       => number_format((float)$decrypted_reward, 2, '.', ''),
            'My_Reffer_Code' => $row['My_Reffer_Code'],
            'Total_Deposit'  => number_format((float)$row['Total_Deposit'], 2, '.', ''),
            'Total_Spend'    => number_format((float)$row['Total_Spend'], 2, '.', '')
        ]
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}

$conn->close();
?>
