<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');
require 'get-access-token.php';

$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Get encrypted inputs
$encrypted_user_id   = $requestData['id'] ?? '';
$encrypted_pin       = $requestData['Pin'] ?? '';
$encrypted_root_amount = $requestData['Root_amount'] ?? '';
$encrypted_oparator  = $requestData['oparator'] ?? '';
$encrypted_trx_id    = $requestData['trx_id'] ?? '';
$encrypted_number    = $requestData['number'] ?? '';
$encrypted_note      = $requestData['note'] ?? '';
$encrypted_methode   = $requestData['Methode'] ?? '';

// Validate required fields
if (empty($encrypted_user_id) || empty($encrypted_pin) || empty($encrypted_root_amount) || empty($encrypted_number)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID, PIN, and Root amount are required']);
    exit();
}

// Decrypt inputs
$user_id     = decryptData($encrypted_user_id);
$pin         = decryptData($encrypted_pin);
$root_amount = decryptData($encrypted_root_amount);
$oparator    = decryptData($encrypted_oparator);
$trx_id      = decryptData($encrypted_trx_id);
$phone_number= decryptData($encrypted_number);
$note        = decryptData($encrypted_note);
$methode     = decryptData($encrypted_methode);

// Validate decrypted values
if (empty($user_id) || empty($pin) || empty($root_amount) || $root_amount <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID, PIN, or Root amount']);
    exit();
}

// Check if TRX_ID already exists
$sqlCheckTrx = "SELECT Trx_ID FROM Send_money_History WHERE Trx_ID = ?";
$stmtCheckTrx = $conn->prepare($sqlCheckTrx);
$stmtCheckTrx->bind_param("s", $trx_id);
$stmtCheckTrx->execute();
$resultCheckTrx = $stmtCheckTrx->get_result();
$stmtCheckTrx->close();

if ($resultCheckTrx->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Transaction ID already exists']);
    exit();
}

// Fetch user PIN, balance, verification status
$sql = "SELECT PIN, Balance, Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$row = $result->fetch_assoc();

// Decrypt stored PIN and Balance
$stored_pin      = decryptSensitive($row['PIN']);
$current_balance = (float) decryptSensitive($row['Balance']);
$veryfi_status   = $row['Veryfi_Status'];

// Check verification
if ($veryfi_status != 1) {
    echo json_encode(['status' => 'error', 'message' => 'Please verify your account before proceeding']);
    exit();
}

// Check PIN match
if ($pin !== $stored_pin) {
    echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
    exit();
}
 // Fetch App_Setting charges
    $chargeSql = "SELECT 
        Bkash_Send_money_Chage_Amount,
        Bkash_Cash_Out_Chage_Amount,
        Nagad_Send_money_Chage_Amount,
        Nagad_Cash_Out_Chage_Amount,
        Rocket_Cash_Out_Chage_Amount,
        Rocket_Send_money_Chage_Amount 
        FROM App_Setting LIMIT 1";
    $chargeResult = $conn->query($chargeSql);
    $chargeRow = $chargeResult->fetch_assoc();

// Check balance sufficiency
// First determine charge amount based on method/option
if (strpos($methode, "Bkash") !== false && strpos($oparator, "Send_Money") !== false) {
    $charge_amount = (float) $chargeRow['Bkash_Send_money_Chage_Amount'];
} elseif (strpos($methode, "Bkash") !== false && strpos($oparator, "Cash_out") !== false) {
    $charge_amount = (float) $chargeRow['Bkash_Cash_Out_Chage_Amount'];
} elseif (strpos($methode, "Nagad") !== false && strpos($oparator, "Send_Money") !== false) {
    $charge_amount = (float) $chargeRow['Nagad_Send_money_Chage_Amount'];
} elseif (strpos($methode, "Nagad") !== false && strpos($oparator, "Cash_out") !== false) {
    $charge_amount = (float) $chargeRow['Nagad_Cash_Out_Chage_Amount'];
} elseif (strpos($methode, "Rocket") !== false && strpos($oparator, "Send_Money") !== false) {
    $charge_amount = (float) $chargeRow['Rocket_Send_money_Chage_Amount'];
} elseif (strpos($methode, "Rocket") !== false && strpos($oparator, "Cash_out") !== false) {
    $charge_amount = (float) $chargeRow['Rocket_Cash_Out_Chage_Amount'];
} else {
    $charge_amount = 0; // default if no match
}

// Calculate charge and balances
$charge        = $charge_amount * ($root_amount / 1000);
$total_amount  = $root_amount + $charge;
$final_balance = $current_balance - $total_amount;

if ($final_balance >= 0) {
    $conn->begin_transaction();

    // Encrypt new balance before saving
    $encrypted_new_balance = encryptSensitive($final_balance);

    $updateSql = "UPDATE USER_DATABSE_PIN SET Balance = ? WHERE id = ?";
    $stmtUpdate = $conn->prepare($updateSql);
    $stmtUpdate->bind_param("si", $encrypted_new_balance, $user_id);

    if ($stmtUpdate->execute()) {
        $sqlInsert = "INSERT INTO Send_money_History 
            (User_ID, Phone_number, Root_amount, Total_Amount, Status, Date, Trx_ID, Oparator, Note, Methode)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmtInsert = $conn->prepare($sqlInsert);
        $status = "Pending";
        $current_date = date("Y-m-d h:i A");

        $stmtInsert->bind_param(
            "isddssssss",
            $user_id,
            $phone_number,
            $root_amount,
            $total_amount,
            $status,
            $current_date,
            $trx_id,
            $oparator,
            $note,
            $methode
        );

        if ($stmtInsert->execute()) {
            $conn->commit();
            echo json_encode(['status' => 'success', 'message' => 'Transaction successful']);

            // 🔔 Send FCM notification to admins
            try {
                $adminTokenSql = "SELECT FCM_Token FROM Admin_Login WHERE LENGTH(FCM_Token) > 100";
                $adminTokenResult = $conn->query($adminTokenSql);

                if ($adminTokenResult->num_rows > 0) {
                    $accessToken = getAccessToken('service-account-file.json');
                    $title = "New " . $oparator . " " . $methode . " Request";
                    $body  = "User requested ৳" . number_format($root_amount, 2) .
                             " (Charge: ৳" . number_format($charge, 2) . ") to " . $phone_number .
                             " (Trx ID: $trx_id).";

                    $headers = [
                        'Content-Type: application/json',
                        'Authorization: Bearer ' . $accessToken
                    ];

                    while ($adminRow = $adminTokenResult->fetch_assoc()) {
                        $fcm_token = $adminRow['FCM_Token'];

                        $payload = json_encode([
                            'message' => [
                                'token' => $fcm_token,
                                'data' => [
                                    'title' => $title,
                                    'body'  => $body,
                                    'type'  => 'send_money'
                                ]
                            ]
                        ]);

                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $fcmResponse = curl_exec($ch);
                        if ($fcmResponse === FALSE) {
                            error_log("FCM Send Error: " . curl_error($ch));
                        } else {
                            error_log("FCM Response: " . $fcmResponse);
                        }
                        curl_close($ch);
                    }
                }
            } catch (Exception $e) {
                error_log("FCM Notification Error: " . $e->getMessage());
            }
        } else {
            $conn->rollback();
            echo json_encode(['status' => 'error', 'message' => 'Transaction succeeded, but history insert failed']);
        }
        $stmtInsert->close();
    } else {
        $conn->rollback();
        echo json_encode(['status' => 'error', 'message' => 'Failed to update balance']);
    }
    $stmtUpdate->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Insufficient balance']);
}

$conn->close();
?>