<?php
header("Content-Type: application/json; charset=UTF-8");

// Include connection and decryption/validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

// Retrieve raw input data
$rawInput = file_get_contents("php://input");
error_log("Raw Input Data: $rawInput"); // Log raw input for debugging

// Decode JSON data
$data = json_decode($rawInput, true);

// Check for JSON decoding errors
if (json_last_error() !== JSON_ERROR_NONE) {
    error_log("JSON Decode Error: " . json_last_error_msg());
    echo json_encode(["status" => "error", "message" => "Malformed JSON."]);
    exit();
}

// Extract parameters
$api_key = $data['api_key'] ?? null;

// Validate API key
$apiKeyValidation = validateApiKey($api_key);
if (!$apiKeyValidation['status']) {
    echo json_encode(["status" => "error", "message" => $apiKeyValidation['message']]);
    exit();
}

// Fetch all notices from the Notice table
$sql = "SELECT Title, Massage, Date_Time FROM Notice";
$result = $conn->query($sql);

if ($result === false) {
    echo json_encode(["status" => "error", "message" => "Failed to fetch notices: " . $conn->error]);
} else {
    if ($result->num_rows > 0) {
        $notices = [];
        while ($row = $result->fetch_assoc()) {
            $notices[] = $row; // Add each notice to the array
        }
        echo json_encode(["status" => "success", "data" => $notices]);
    } else {
        echo json_encode(["status" => "error", "message" => "No notices found."]);
    }
}

// Close connection
$conn->close();
?>