<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debugging log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate and Decrypt User ID
$encrypted_user_id = $requestData['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    exit();
}

// Step 3: Check User Block Status in `User_Database`
$blockCheckSql = "SELECT Block FROM USER_DATABSE_PIN WHERE id = ?";
$stmtBlockCheck = $conn->prepare($blockCheckSql);
$stmtBlockCheck->bind_param("i", $user_id);
$stmtBlockCheck->execute();
$resultBlock = $stmtBlockCheck->get_result();
$stmtBlockCheck->close();

if ($resultBlock->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$userData = $resultBlock->fetch_assoc();
$block_status = (int) $userData['Block'];

// Step 4: Return User Status
if ($block_status === 1) {
    echo json_encode(['status' => 'success', 'message' => 'Block']);
} else {
    echo json_encode(['status' => 'success', 'message' => 'Active']);
}

$conn->close();
?>
