<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

date_default_timezone_set('Asia/Dhaka'); // Set timezone

// Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

//$conn->query("SET SESSION query_cache_type = OFF;");

// Get and decrypt request data
$phone_enc = $_POST['phone'] ?? '';
$pin_enc   = $_POST['pin'] ?? '';
$fcm_token = $_POST['fcm_token'] ?? '';

$dphone = decryptData($phone_enc);
$dpin   = decryptData($pin_enc);

if (empty($dphone) || empty($dpin)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid phone or password.']);
    $conn->close();
    exit();
}

// --- Fetch all users (we can’t filter directly since fields are encrypted) ---
$sql = "SELECT id, Frist_Name, Last_Name, Email, Phone_number, User_Password, My_Reffer_Code, 
               FCM_Token, Selfi_photo, Device_login, Block 
        FROM USER_DATABSE_PIN";
$result = $conn->query($sql);

if (!$result || $result->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'No users found.']);
    $conn->close();
    exit();
}

$foundUser = null;

// --- Decrypt each user and compare ---
while ($row = $result->fetch_assoc()) {
    $dec_phone = decryptSensitive($row['Phone_number']);
    $dec_pass  = decryptSensitive($row['User_Password']);

    if ($dec_phone === $dphone && $dec_pass === $dpin) {
        $foundUser = $row;
        break;
    }
}

if (!$foundUser) {
    echo json_encode(['status' => 'error', 'message' => 'Phone number or password does not match.']);
    $conn->close();
    exit();
}

// --- Check if account is blocked ---
if ($foundUser['Block'] == 1) {
    echo json_encode(['status' => 'error', 'message' => 'Your account is blocked. Please contact admin.']);
    $conn->close();
    exit();
}

// --- Update device info ---
$update = $conn->prepare("UPDATE USER_DATABSE_PIN SET Device_login = 1, FCM_Token = ? WHERE id = ?");
$update->bind_param("si", $fcm_token, $foundUser['id']);
$update->execute();
$update->close();

// --- Success response ---
echo json_encode([
    'status' => 'success',
    'message' => 'Login successful',
    'id' => $foundUser['id'],
    'Frist_Name' => $foundUser['Frist_Name'],
    'Last_Name' => $foundUser['Last_Name'],
    'Email' => decryptSensitive($foundUser['Email']),
    'My_Reffer_Code' => $foundUser['My_Reffer_Code'],
    'Selfi_photo' => $foundUser['Selfi_photo'],
    'FCM_Token' => $fcm_token,
    'Device_login' => 1
]);

$conn->close();
?>
