<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Read JSON input
$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Validate User ID
$encrypted_user_id = $requestData['User_id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Fetch all users sorted numerically by Total_Spend
$sql = "SELECT id, Phone_Number, Total_Spend, Balance, Veryfi_Status, Reward 
        FROM USER_DATABSE_PIN 
        ORDER BY CAST(Total_Spend AS DECIMAL(10,2)) DESC";
$result = $conn->query($sql);

$topUsers = [];
$otherUsers = [];
$userCount = 0;
$currentUserData = null;

while ($row = $result->fetch_assoc()) {
    $userCount++;

    // 🔑 Decrypt sensitive fields
    $decryptedPhone   = !empty($row['Phone_Number']) ? decryptSensitive($row['Phone_Number']) : null;
    $decryptedBalance = !empty($row['Balance']) ? (float) decryptSensitive($row['Balance']) : 0.0;
    $decryptedReward  = !empty($row['Reward']) ? decryptSensitive($row['Reward']) : null;

    $userData = [
        'id'            => $row['id'],
        'Phone_Number'  => $decryptedPhone,
        'Total_Spend'   => number_format((float)$row['Total_Spend'], 2, '.', ''),
        'Balance'       => number_format($decryptedBalance, 2, '.', ''),
        'Veryfi_Status' => $row['Veryfi_Status'],
        'Reward'        => $decryptedReward,
        'Rank'          => $userCount
    ];

    // Track current user
    if ($row['id'] == $user_id) {
        $currentUserData = $userData;
    }

    // Top 3 users
    if ($userCount <= 3) {
        $topUsers[] = $userData;
    } else {
        $otherUsers[] = $userData;
    }
}

// Send response
echo json_encode([
    'status'      => 'success',
    'message'     => 'User data retrieved successfully',
    'topUsers'    => $topUsers,
    'otherUsers'  => $otherUsers,
    'currentUser' => $currentUserData
]);

$conn->close();
?>