<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);
error_log("Raw POST Data: " . file_get_contents("php://input"));


if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debugging log for received JSON
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate User ID
$encrypted_user_id = $requestData['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    exit();
}

// Step 3: Check User Verification Status in `User_Database`
$verifyCheckSql = "SELECT Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmtVerifyCheck = $conn->prepare($verifyCheckSql);
$stmtVerifyCheck->bind_param("i", $user_id);
$stmtVerifyCheck->execute();
$resultVerify = $stmtVerifyCheck->get_result();
$stmtVerifyCheck->close();

if ($resultVerify->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$userData = $resultVerify->fetch_assoc();
$verification_status = $userData['Veryfi_Status'];

// Step 4: Determine Response Based on Verification Status
if ($verification_status == 1) {
    echo json_encode(['status' => 'success', 'message' => 'Verified']);
} else {
    // Step 5: Check Pending Verification Requests in `NID_Verify_Request`
    $pendingCheckSql = "SELECT Status FROM NID_Verify_Request WHERE User_ID = ? AND Status = 'Pending'";
    $stmtPendingCheck = $conn->prepare($pendingCheckSql);
    $stmtPendingCheck->bind_param("i", $user_id);
    $stmtPendingCheck->execute();
    $resultPending = $stmtPendingCheck->get_result();
    $stmtPendingCheck->close();

    if ($resultPending->num_rows > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Pending Verification']);
    } else {
        echo json_encode(['status' => 'success', 'message' => 'No pending request']);
    }
}

$conn->close();
?>
