<?php
// Include database connection and validation files

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');
header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON input
$requestData = json_decode(file_get_contents("php://input"), true);

// Check for valid JSON input
if (json_last_error() !== JSON_ERROR_NONE || !is_array($requestData)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid JSON format or missing data'
    ]);
    exit();
}

// Debug log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKey = $requestData['api_key'] ?? null;
$apiKeyValidation = validateApiKey($apiKey);

if (!$apiKeyValidation['status']) {
    echo json_encode([
        'status' => 'error',
        'message' => $apiKeyValidation['message']
    ]);
    exit();
}

// Step 2: Fetch Images & Click URLs from Database
$imageFetchSql = "SELECT Image, Click_link_Url FROM Image_Slider";
$resultImages = $conn->query($imageFetchSql);

if (!$resultImages) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database query failed'
    ]);
    exit();
}

$data = [];
while ($row = $resultImages->fetch_assoc()) {
    $data[] = [
        'image' => $row['Image'],
        'url' => $row['Click_link_Url']
    ];
}

// Step 3: Return JSON Response
if (!empty($data)) {
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'No images found'
    ]);
}

$conn->close();
?>
