<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');


try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['API__K_E_Y'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    date_default_timezone_set('Asia/Dhaka');

    // SQL query to fetch data
    $sql = "SELECT id, USDT_Rate, Limite_Balance, Available_usdt, Bkash, Nagad, Rocket, Celfin, Bank, Limit_To_BUY_USDT FROM Binance_Sell_details";
    $result = $conn->query($sql);

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Return success JSON
    echo json_encode(['status' => 'success', 'data' => $data]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>