<?php
// Include database connection file and decryption/validation methods
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Read POST data
$requestData = json_decode(file_get_contents("php://input"), true);

// Get encrypted API key
$encryptedApiKey = $requestData['api_key'] ?? null;
if (empty($encryptedApiKey)) {
    echo json_encode(['status' => 'error', 'message' => 'API key missing']);
    exit();
}

// Decrypt the API key
$decryptedApiKey = decryptData($encryptedApiKey); // decryptData() function from decrypt_and_validate.php
if (!$decryptedApiKey) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt API key']);
    exit();
}

// Validate the decrypted API key
// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}
// Fetch bank names from database
$sql = "SELECT id, Bank_Name, Bank_Image FROM Bank_Tranfar_bank_name";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $bankList = [];
    while ($row = $result->fetch_assoc()) {
        $bankList[] = [
            'id' => $row['id'],
            'Bank_Name' => $row['Bank_Name'],
             'Bank_Image' => $row['Bank_Image']
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $bankList]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No banks found']);
}

$conn->close();
?>