<?php
// Include DB connection and decryption files
include 'connection.php';
include 'decryption_api_key.php';

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

// Step 1: Check for API key
if (!isset($requestData['api_key'])) {
    echo json_encode(['status' => 'error', 'message' => 'API key missing']);
    exit();
}

// Step 2: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key']);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 3: Fetch all App_Setting fields
$sql = "SELECT 
    id,
    App_ON_OFF,
    Recharge_ON_OFF,
    Bkash_ON_OFF,
    Nagad_ON_OFF,
    Rocket_ON_OFF,
    VPN_Card_ON_OFF	,
    Calling_Card_ON_OFF,
    Screacth_PIN_ON_OFF,
    Binance_ON_OFF,
    Drive_Offer_ON_OFF,
    Bank_ON_OFF,
    Add_Money_On_OFF,
    
    Bkash_Cash_OUT_Minimum_Amount,Bkash_Cash_OUT_Max_Amount,Nagad_Cash_OUT_Minimum_Amount,Nagad_Cash_OUT_Max_Amount,
    Rocket_Cash_OUT_Minimum_Amount,Rocket_Cash_OUT_Max_Amount,
    
    Live_Notice,
    Bkash_Minimum_Amount,
    Bkash_Max_Amount,
    Nagad_Minimum_Amount,
    Nagad_Max_Amount,
    Rocket_Minimum_Amount,
    Rocket_Max_Amount,
    Recharge_Minimum_Amount,
    Recharge_Max_Amount,
    App_Version,
    App_Link,
    Reward_Amount,
live_notice_text_Color,
    WhatsApp,
    Telegram,
    Minimum_bank_amount,
    Maximum_bank_amount
FROM App_Setting
LIMIT 1";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $settings = $result->fetch_assoc();
    echo json_encode([
        'status' => 'success',
        'message' => 'Settings fetched successfully',
        'data' => $settings
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found']);
}

$conn->close();
?>
