<?php
// Include connection and validation files

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// **Read API key and user ID from form data (NOT JSON)**
$api_key = $_POST['api_key'] ?? null;
$encrypted_user_id = $_POST['id'] ?? '';

if (!$api_key) {
    echo json_encode(['status' => 'error', 'message' => 'API key missing']);
    exit();
}

// Validate API key
$apiKeyValidation = validateApiKey($api_key);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Validate user ID
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    exit();
}

// Decrypt user ID
$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID']);
    exit();
}

// Fetch user's transaction history from Cash_out_History
$sql = "SELECT User_ID, How_Much, Reasone, Date
        FROM History WHERE User_ID = ? ORDER BY Date DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

$transactions = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $transactions[] = [
            'User_ID' => $row['User_ID'],
            'How_Much' => $row['How_Much'],
            'Reasone' => $row['Reasone'],
            'Date' => $row['Date']
            
        
        ];
    }
    echo json_encode(['status' => 'success', 'data' => $transactions]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No transactions found']);
}

$conn->close();
?>