<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Get encrypted inputs
$encrypted_user_id = $requestData['id'] ?? '';
$encrypted_pin = $requestData['Pin'] ?? '';
$encrypted_root_amount = $requestData['Root_amount'] ?? '';

if (empty($encrypted_user_id) || empty($encrypted_pin) || empty($encrypted_root_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID, PIN, and Root amount are required']);
    exit();
}

// Decrypt inputs (NOT sensitive — these are coming from the app)
$user_id = decryptData($encrypted_user_id);
$pin = decryptData($encrypted_pin);
$root_amount = decryptData($encrypted_root_amount);

if (empty($user_id) || empty($pin) || empty($root_amount) || $root_amount <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID, PIN, or Root amount']);
    exit();
}

// Fetch app settings
$settingSql = "SELECT Recharge_ON_OFF, Recharge_Minimum_Amount, Recharge_Max_Amount 
               FROM App_Setting LIMIT 1";
$settingResult = $conn->query($settingSql);

if ($settingResult->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found']);
    exit();
}

$appSettings = $settingResult->fetch_assoc();

// Check Mobile Recharge status
if ($appSettings['Recharge_ON_OFF'] == 1) {
    echo json_encode(['status' => 'error', 'message' => 'Recharge now off']);
    exit();
}

// Check recharge limits
$min_amount = $appSettings['Recharge_Minimum_Amount'];
$max_amount = $appSettings['Recharge_Max_Amount'];

if ($root_amount < $min_amount || $root_amount > $max_amount) {
    echo json_encode([
        'status' => 'error',
        'message' => "Recharge amount must be between {$min_amount} and {$max_amount}"
    ]);
    exit();
}

// Fetch encrypted PIN & BALANCE from DB
$sql = "SELECT PIN, Balance, Veryfi_Status 
        FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$row = $result->fetch_assoc();

// ----------- 🔐 DECRYPT SENSITIVE DATABASE VALUES -------------
$stored_pin = decryptSensitive($row['PIN']);        // FOR PIN
$current_balance = decryptSensitive($row['Balance']); // FOR BALANCE
$veryfi_status = $row['Veryfi_Status'];

if (!is_numeric($current_balance)) {
    echo json_encode(['status' => 'error', 'message' => 'Corrupted balance data']);
    exit();
}
// --------------------------------------------------------------

// Check verification status
if ($veryfi_status != 1) {
    echo json_encode(['status' => 'error', 'message' => 'Please verify your account before proceeding']);
    exit();
}

// Check PIN
if ($pin !== $stored_pin) {
    echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
    exit();
}

// Balance checks
$remaining_balance = $current_balance - $root_amount;

if ($remaining_balance >= 0) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Balance and PIN are valid',
        'current_balance' => $current_balance,
        'remaining_balance' => $remaining_balance,
        'final_balance' => $remaining_balance
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Insufficient balance',
        'current_balance' => $current_balance,
        'remaining_balance' => null,
        'final_balance' => null
    ]);
}

$conn->close();
?>
