<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Read POST data
$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Get encrypted user ID, PIN, and Root amount
$encrypted_user_id     = $requestData['id'] ?? '';
$encrypted_pin         = $requestData['Pin'] ?? '';
$encrypted_root_amount = $requestData['Root_amount'] ?? '';
$encrypted_option      = $requestData['Option'] ?? '';
$encrypted_methode     = $requestData['Methode'] ?? '';

if (empty($encrypted_user_id) || empty($encrypted_pin) || empty($encrypted_root_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID, PIN, and Root amount are required']);
    exit();
}

// Decrypt user ID, PIN, and Root amount
$user_id     = decryptData($encrypted_user_id);
$pin         = decryptData($encrypted_pin);
$root_amount = (float) decryptData($encrypted_root_amount);
$option      = decryptData($encrypted_option);
$method      = decryptData($encrypted_methode);

if (empty($user_id) || empty($pin) || $root_amount <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID, PIN, or Root amount']);
    exit();
}

// Fetch user's PIN, Balance, and Veryfi_Status from the database
$sql = "SELECT PIN, Balance, Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // Decrypt stored PIN and Balance
    $stored_pin      = decryptSensitive($row['PIN']);
    $current_balance = (float) decryptSensitive($row['Balance']);
    $veryfi_status   = $row['Veryfi_Status'];

    // Check if user is verified
    if ($veryfi_status != 1) {
        echo json_encode(['status' => 'error', 'message' => 'Please verify your account before proceeding']);
        exit();
    }

    // Check if the provided PIN matches the stored PIN
    if ($pin !== $stored_pin) {
        echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
        exit();
    }

    // Fetch App_Setting charges
    $chargeSql = "SELECT 
        Bkash_Send_money_Chage_Amount,
        Bkash_Cash_Out_Chage_Amount,
        Nagad_Send_money_Chage_Amount,
        Nagad_Cash_Out_Chage_Amount,
        Rocket_Cash_Out_Chage_Amount,
        Rocket_Send_money_Chage_Amount 
        FROM App_Setting LIMIT 1";
    $chargeResult = $conn->query($chargeSql);
    $chargeRow = $chargeResult->fetch_assoc();

    $charge_amount = 0;

    // Determine charge based on method and option
    if (strpos($method, "Bkash") !== false && strpos($option, "Send_Money") !== false) {
        $charge_amount = (float) $chargeRow['Bkash_Send_money_Chage_Amount'];
    } elseif (strpos($method, "Bkash") !== false && strpos($option, "Cash_out") !== false) {
        $charge_amount = (float) $chargeRow['Bkash_Cash_Out_Chage_Amount'];
    } elseif (strpos($method, "Nagad") !== false && strpos($option, "Send_Money") !== false) {
        $charge_amount = (float) $chargeRow['Nagad_Send_money_Chage_Amount'];
    } elseif (strpos($method, "Nagad") !== false && strpos($option, "Cash_out") !== false) {
        $charge_amount = (float) $chargeRow['Nagad_Cash_Out_Chage_Amount'];
    } elseif (strpos($method, "Rocket") !== false && strpos($option, "Send_Money") !== false) {
        $charge_amount = (float) $chargeRow['Rocket_Send_money_Chage_Amount'];
    } elseif (strpos($method, "Rocket") !== false && strpos($option, "Cash_out") !== false) {
        $charge_amount = (float) $chargeRow['Rocket_Cash_Out_Chage_Amount'];
    }

    // Calculate charge based on root amount
    $charge = ($charge_amount * ($root_amount / 1000));
    $total_charge_amount = $root_amount + $charge;
    $remaining_balance = $current_balance - $total_charge_amount;
    $final_balance = $remaining_balance;

    if ($remaining_balance >= 0) {
        echo json_encode([
            'status'            => 'success',
            'message'           => 'Balance and PIN are valid',
            'current_balance'   => $current_balance,
            'remaining_balance' => $remaining_balance,
            'final_balance'     => $final_balance,
            'charge_am'         => $charge,
            'total_charge_am'   => $total_charge_amount
        ]);
    } else {
        echo json_encode([
            'status'            => 'error',
            'message'           => 'Insufficient balance',
            'current_balance'   => $current_balance,
            'remaining_balance' => $remaining_balance,
            'final_balance'     => null,
            'charge_am'         => $charge,
            'total_charge_am'   => $total_charge_amount
        ]);
    }

} else {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}

$conn->close();
?>