<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Get encrypted inputs
$encrypted_user_id   = $requestData['id'] ?? '';
$encrypted_pin       = $requestData['Pin'] ?? '';
$encrypted_root_amount = $requestData['Root_amount'] ?? '';

if (empty($encrypted_user_id) || empty($encrypted_pin) || empty($encrypted_root_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID, PIN, and Root amount are required']);
    exit();
}

// Decrypt inputs
$user_id     = decryptData($encrypted_user_id);
$pin         = decryptData($encrypted_pin);
$root_amount = decryptData($encrypted_root_amount);

if (empty($user_id) || empty($pin) || empty($root_amount) || $root_amount <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID, PIN, or Root amount']);
    exit();
}

// Fetch PIN, Balance, and Veryfi_Status
$sql = "SELECT PIN, Balance, Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // 🔑 Decrypt stored PIN and Balance
    $stored_pin      = decryptSensitive($row['PIN']);
    $current_balance = (float) decryptSensitive($row['Balance']);
    $veryfi_status   = $row['Veryfi_Status'];

    if ($veryfi_status != 1) {
        echo json_encode(['status' => 'error', 'message' => 'Please verify your account before proceeding']);
        exit();
    }

    if ($pin !== $stored_pin) {
        echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
        exit();
    }

    $remaining_balance = $current_balance - $root_amount;

    if ($remaining_balance >= 0) {
        // Default charge amount = 0
        $charge_amount = 0;
        $charge = 0;
        $total_charge_amount = $root_amount + $charge;
        $final_balance = $remaining_balance - $charge;

        echo json_encode([
            'status'            => 'success',
            'message'           => 'Balance and PIN are valid',
            'total_charge_am'   => $total_charge_amount,
            'charge_am'         => $charge,
            'current_balance'   => $current_balance,
            'remaining_balance' => $remaining_balance,
            'final_balance'     => $final_balance
        ]);
    } else {
        echo json_encode([
            'status'            => 'error',
            'message'           => 'Insufficient balance',
            'current_balance'   => $current_balance,
            'remaining_balance' => $remaining_balance,
            'final_balance'     => null
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}

$conn->close();
?>