<?php

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Use $_POST instead of raw JSON
$apiKey = $_POST['API_Key'] ?? null;
$encrypted_email = $_POST['email'] ?? '';

/*
|--------------------------------------------------------------------------
| Step 1: Validate API Key
|--------------------------------------------------------------------------
*/
$apiKeyValidation = validateApiKey($apiKey);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

/*
|--------------------------------------------------------------------------
| Step 2: Validate & Decrypt Given Email
|--------------------------------------------------------------------------
*/
if (empty($encrypted_email)) {
    echo json_encode(['status' => 'error', 'message' => 'Email is required']);
    exit();
}

$decrypted_email = decryptData($encrypted_email);

if (empty($decrypted_email)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt email']);
    exit();
}

/*
|--------------------------------------------------------------------------
| Step 3: Compare With ENCRYPTED Emails in Database
|--------------------------------------------------------------------------
| We cannot search directly because emails are encrypted.
| So: fetch all encrypted emails → decrypt → compare one by one
|--------------------------------------------------------------------------
*/

$sql = "SELECT Email FROM USER_DATABSE_PIN";
$result = $conn->query($sql);

$emailFound = false;

if ($result && $result->num_rows > 0) {

    while ($row = $result->fetch_assoc()) {

        $encryptedEmailFromDb = $row['Email'];
        $dbEmailDecrypted = decryptSensitive($encryptedEmailFromDb);

        if (!empty($dbEmailDecrypted) && $dbEmailDecrypted === $decrypted_email) {
            $emailFound = true;
            break;
        }
    }
}

/*
|--------------------------------------------------------------------------
| Step 4: Response
|--------------------------------------------------------------------------
*/
if ($emailFound) {
    echo json_encode(['status' => 'success', 'message' => 'Email exists']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No email found']);
}

$conn->close();
?>
