<?php

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

$requestData = json_decode(file_get_contents("php://input"), true);

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Extract encrypted inputs
$encrypted_user_id = $requestData['id'] ?? '';
$encrypted_pin     = $requestData['PIN'] ?? '';
$encrypted_amount  = $requestData['amount'] ?? '';

// Check for required fields
if (empty($encrypted_user_id) || empty($encrypted_pin) || empty($encrypted_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID, PIN, and Amount are required']);
    exit();
}

// Decrypt values from request
$user_id = decryptData($encrypted_user_id);
$pin     = decryptData($encrypted_pin);
$amount  = decryptData($encrypted_amount);

// Validate decrypted inputs
if (empty($user_id) || empty($pin) || empty($amount) || !is_numeric($amount) || $amount <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or failed to decrypt User ID, PIN, or Amount']);
    exit();
}

// Fetch user's PIN, Balance, and Veryfi_Status
$sql = "SELECT PIN, Balance, Veryfi_Status FROM USER_DATABSE_PIN WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$stmt->close();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // 🔑 Decrypt stored PIN and Balance before checking
    $stored_pin      = decryptSensitive($row['PIN']);
    $current_balance = (float) decryptSensitive($row['Balance']);
    $veryfi_status   = $row['Veryfi_Status'];

    if ($veryfi_status != 1) {
        echo json_encode(['status' => 'error', 'message' => 'Please verify your account before checking balance']);
        exit();
    }

    $remaining_balance = $current_balance - $amount;

    if ($pin !== $stored_pin) {
        echo json_encode(['status' => 'error', 'message' => 'Incorrect PIN']);
    } elseif ($remaining_balance >= 0) {
        echo json_encode([
            'status'        => 'success',
            'message'       => 'Balance OK',
            'final_balance' => $remaining_balance
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Insufficient balance']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
}

$conn->close();
?>