<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Step 2: Validate User ID
$encrypted_user_id = $_POST['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Step 3: Validate PINs
$encrypted_old_pin = $_POST['Old_PIN'] ?? '';
$encrypted_new_pin = $_POST['New_PIN'] ?? '';

if (empty($encrypted_old_pin) || empty($encrypted_new_pin)) {
    echo json_encode(['status' => 'error', 'message' => 'Old PIN and New PIN are required']);
    $conn->close();
    exit();
}

// Decrypt PINs from app
$old_pin = decryptData($encrypted_old_pin);
$new_pin = decryptData($encrypted_new_pin);

if (empty($old_pin) || empty($new_pin)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt PINs']);
    $conn->close();
    exit();
}

// Step 4: Fetch encrypted PIN from database
$checkPinSql = "SELECT PIN FROM USER_DATABSE_PIN WHERE id = ?";
$stmtCheckPin = $conn->prepare($checkPinSql);
$stmtCheckPin->bind_param("i", $user_id);
$stmtCheckPin->execute();
$resultCheckPin = $stmtCheckPin->get_result();
$stmtCheckPin->close();

if ($resultCheckPin->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    $conn->close();
    exit();
}

$userData = $resultCheckPin->fetch_assoc();
$dbEncryptedPin = $userData['PIN'];

// Decrypt DB PIN
$dbDecryptedPin = decryptSensitive($dbEncryptedPin);

// Step 5: Match old PIN
if ($dbDecryptedPin !== $old_pin) {
    echo json_encode(['status' => 'error', 'message' => 'Old PIN does not match']);
    $conn->close();
    exit();
}

// Step 6: Validate new PIN length (4–5 digits)
if (!preg_match('/^\d{4,5}$/', $new_pin)) {
    echo json_encode(['status' => 'error', 'message' => 'Enter a PIN between 4 to 5 digits']);
    $conn->close();
    exit();
}

// Step 7: Encrypt new PIN before saving
$encryptedNewPinToSave = encryptSensitive($new_pin);

// Step 8: Update PIN
$updatePinSql = "UPDATE USER_DATABSE_PIN SET PIN = ? WHERE id = ?";
$stmtUpdatePin = $conn->prepare($updatePinSql);
$stmtUpdatePin->bind_param("si", $encryptedNewPinToSave, $user_id);

if ($stmtUpdatePin->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'PIN changed successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update PIN']);
}

$stmtUpdatePin->close();
$conn->close();
?>
