<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Step 2: Validate encrypted User ID
$encrypted_user_id = $_POST['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

// Decrypt User ID
$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Step 3: Validate encrypted Passwords
$encrypted_old_pin = $_POST['Old_password'] ?? '';
$encrypted_new_pin = $_POST['New_password'] ?? '';

if (empty($encrypted_old_pin) || empty($encrypted_new_pin)) {
    echo json_encode(['status' => 'error', 'message' => 'Old Password and New Password are required']);
    $conn->close();
    exit();
}

// Decrypt Passwords
$old_pin = decryptData($encrypted_old_pin);
$new_pin = decryptData($encrypted_new_pin);

if (empty($old_pin) || empty($new_pin)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt passwords']);
    $conn->close();
    exit();
}

// Step 4: Get encrypted password from DB
$sqlCheck = "SELECT User_Password FROM USER_DATABSE_PIN WHERE id = ?";
$stmtCheck = $conn->prepare($sqlCheck);
$stmtCheck->bind_param("i", $user_id);
$stmtCheck->execute();
$resultCheck = $stmtCheck->get_result();
$stmtCheck->close();

if ($resultCheck->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    $conn->close();
    exit();
}

$user = $resultCheck->fetch_assoc();
$encrypted_password_in_db = $user['User_Password'];

// Step 5: Decrypt stored password
$decrypted_password_in_db = decryptSensitive($encrypted_password_in_db);

// Step 6: Compare passwords
if ($decrypted_password_in_db !== $old_pin) {
    echo json_encode(['status' => 'error', 'message' => 'Old Password does not match']);
    $conn->close();
    exit();
}

// Step 7: Validate new password length
if (strlen($new_pin) < 8 || strlen($new_pin) > 15) {
    echo json_encode(['status' => 'error', 'message' => 'Password must be 8–15 characters long']);
    $conn->close();
    exit();
}

// Step 8: Encrypt NEW password before storing
$encrypted_new_password = encryptSensitive($new_pin);

// Step 9: Update password inside table USER_DATABSE_PIN
$updatePinSql = "UPDATE USER_DATABSE_PIN SET User_Password = ? WHERE id = ?";
$stmtUpdatePin = $conn->prepare($updatePinSql);
$stmtUpdatePin->bind_param("si", $encrypted_new_password, $user_id);

if ($stmtUpdatePin->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Password changed successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update Password']);
}

$stmtUpdatePin->close();
$conn->close();
?>
