<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Step 2: Validate User ID
$encrypted_user_id = $_POST['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Step 3: Validate & Decrypt incoming PIN + Phone Number
$encrypted_pin = $_POST['Pin'] ?? '';
$encrypted_phone_number = $_POST['Phone_number'] ?? '';

if (empty($encrypted_pin) || empty($encrypted_phone_number)) {
    echo json_encode(['status' => 'error', 'message' => 'PIN and Phone Number are required']);
    $conn->close();
    exit();
}

$pin = decryptData($encrypted_pin);
$phone_number = decryptData($encrypted_phone_number);

if (empty($pin) || empty($phone_number)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt PIN or Phone Number']);
    $conn->close();
    exit();
}

// Step 4: Get encrypted PIN from DB
$checkPinSql = "SELECT PIN FROM USER_DATABSE_PIN WHERE id = ?";
$stmtCheckPin = $conn->prepare($checkPinSql);
$stmtCheckPin->bind_param("i", $user_id);
$stmtCheckPin->execute();
$resultCheckPin = $stmtCheckPin->get_result();
$stmtCheckPin->close();

if ($resultCheckPin->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    $conn->close();
    exit();
}

$userData = $resultCheckPin->fetch_assoc();
$dbEncryptedPin = $userData['PIN'];

// Decrypt PIN stored in DB
$dbDecryptedPin = decryptSensitive($dbEncryptedPin);

// Step 5: Compare PIN
if ($dbDecryptedPin !== $pin) {
    echo json_encode(['status' => 'error', 'message' => 'PIN does not match']);
    $conn->close();
    exit();
}

// Step 6: Encrypt new phone number before updating database
$encryptedPhoneToSave = encryptSensitive($phone_number);

// Step 7: Update encrypted phone number in DB
$updatePhoneSql = "UPDATE USER_DATABSE_PIN SET Phone_number = ? WHERE id = ?";
$stmtUpdatePhone = $conn->prepare($updatePhoneSql);
$stmtUpdatePhone->bind_param("si", $encryptedPhoneToSave, $user_id);

if ($stmtUpdatePhone->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Phone number updated successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update phone number']);
}

$stmtUpdatePhone->close();
$conn->close();
?>
