<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka'); // Set timezone to Dhaka

// Step 1: Validate API key using POST parameters
$apiKeyValidation = validateApiKey($_POST['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Step 2: Validate User ID
$encrypted_user_id = $_POST['id'] ?? '';
if (empty($encrypted_user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'User ID is required']);
    $conn->close();
    exit();
}

$user_id = decryptData($encrypted_user_id);
if (empty($user_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt User ID']);
    $conn->close();
    exit();
}

// Step 3: Validate and Decrypt First Name & Last Name
$encrypted_first_name = $_POST['First_name'] ?? '';
$encrypted_last_name = $_POST['Last_name'] ?? '';

if (empty($encrypted_first_name) || empty($encrypted_last_name)) {
    echo json_encode(['status' => 'error', 'message' => 'First Name and Last Name are required']);
    $conn->close();
    exit();
}

// Decrypt names
$first_name = decryptData($encrypted_first_name);
$last_name = decryptData($encrypted_last_name);

if (empty($first_name) || empty($last_name)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt First Name or Last Name']);
    $conn->close();
    exit();
}

// Step 4: Update User Name
$updateNameSql = "UPDATE USER_DATABSE_PIN SET Frist_Name = ?, Last_Name = ? WHERE id = ?";
$stmtUpdateName = $conn->prepare($updateNameSql);
$stmtUpdateName->bind_param("ssi", $first_name, $last_name, $user_id);

if ($stmtUpdateName->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Name updated successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update name']);
}

$stmtUpdateName->close();
$conn->close();
?>