<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

try {
    // Validate the API key
    $validation = validateApiKey($_POST['API__K_E_Y'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    date_default_timezone_set('Asia/Dhaka');

    // SQL query to fetch data
    $sql = "SELECT id, Title, Price, Price_OFF, Link, User_Name,Pasword,VPN_APP_link,Details,Image FROM Vpn_Card";
    $result = $conn->query($sql);

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Return data as JSON
    echo json_encode(['status' => true, 'data' => $data]);
} catch (Exception $e) {
    // Return error as JSON
    echo json_encode(['status' => false, 'message' => $e->getMessage()]);
} finally {
    // Close the database connection
    $conn->close();
}
?>