<?php
header('Content-Type: application/json');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/probash3/private/privet_key.php');
require_once('/home/probash3/private/encryption_helper.php');

// ✅ Check if all required POST fields exist
if (
    !isset($_POST['First_Name']) ||
    !isset($_POST['Last_Name']) ||
    !isset($_POST['Email']) ||
    !isset($_POST['Phone_Number']) ||
    !isset($_POST['PIN']) ||
    !isset($_POST['Password']) ||
    !isset($_POST['Reffer_Number_Who_Invited']) ||
    !isset($_POST['api_key'])
) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// ✅ Validate API key
$api_validation = validateApiKey($_POST['api_key']);
if ($api_validation['status'] === false) {
    echo json_encode(['status' => 'error', 'message' => $api_validation['message']]);
    exit;
}

// ✅ Decrypt received client data
$first_name = decryptData($_POST['First_Name']);
$last_name  = decryptData($_POST['Last_Name']);
$email      = decryptData($_POST['Email']);
$phone      = decryptData($_POST['Phone_Number']);
$pin        = decryptData($_POST['PIN']);
$password   = decryptData($_POST['Password']);
$reffer     = decryptData($_POST['Reffer_Number_Who_Invited']);

// ✅ Get current date (Asia/Dhaka)
date_default_timezone_set("Asia/Dhaka");
$joining_date = date('Y-m-d H:i:s');

// ✅ Decrypt stored data to check if email/phone already exists
$existing = $conn->query("SELECT Email, Phone_number FROM USER_DATABSE_PIN");
if ($existing && $existing->num_rows > 0) {
    while ($row = $existing->fetch_assoc()) {
        $decrypted_email = decryptSensitive($row['Email']);
        $decrypted_phone = decryptSensitive($row['Phone_number']);
        
        if (strcasecmp($decrypted_email, $email) === 0) {
            echo json_encode(['status' => 'error', 'message' => 'Email already exists']);
            exit;
        }
        if ($decrypted_phone === $phone) {
            echo json_encode(['status' => 'error', 'message' => 'Phone number already exists']);
            exit;
        }
    }
}

// ✅ Generate a unique 8-digit referral code
function generateUniqueReferralCode($conn) {
    do {
        $ref_code = str_pad(rand(0, 99999999), 8, '0', STR_PAD_LEFT);
        $check_ref = $conn->prepare("SELECT id FROM USER_DATABSE_PIN WHERE My_Reffer_Code = ?");
        $check_ref->bind_param("s", $ref_code);
        $check_ref->execute();
        $check_result = $check_ref->get_result();
    } while ($check_result->num_rows > 0);
    return $ref_code;
}

$my_reffer_code = generateUniqueReferralCode($conn);

// ✅ Get account create bonus
$bonus_query = $conn->query("SELECT Account_Create_Bonus_Amount FROM App_Setting LIMIT 1");

if ($bonus_query && $bonus_query->num_rows > 0) {
    $bonus_row = $bonus_query->fetch_assoc();
    $bonus_amount = floatval($bonus_row['Account_Create_Bonus_Amount']);
}

// ✅ Encrypt sensitive data before storing
$email      = encryptSensitive($email);
$phone      = encryptSensitive($phone);
$pin        = encryptSensitive($pin);
$password   = encryptSensitive($password);
$balanceEnc = encryptSensitive($bonus_amount);
$rewardEnc  = encryptSensitive("0");

// ✅ Insert user data
$insert_user = $conn->prepare("INSERT INTO USER_DATABSE_PIN (
    Frist_Name, Last_Name, Email, Phone_number, PIN, User_Password,
    Who_invite_reffer_code, My_Reffer_Code, Joining_date, Veryfi_Status,
    Total_Deposit, Total_Spend, FCM_Token, Selfi_photo, Nid_Front, Nid_Back,
    Block, Device_login, Reward, Ban_From_Add_money, Device_ID_Name, Balance
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 0, 0, 0, 0, 0, 0, 0, 0, ?, 0, 0, ?)");

$insert_user->bind_param(
    "sssssssssss",
    $first_name,
    $last_name,
    $email,
    $phone,
    $pin,
    $password,
    $reffer,
    $my_reffer_code,
    $joining_date,
    $rewardEnc,
    $balanceEnc
);

if ($insert_user->execute()) {
    $user_id = $insert_user->insert_id;

    // ✅ Insert into Comission table
    $reason = "Account Open Bonus";
    $insert_commission = $conn->prepare("INSERT INTO Comission (User_ID, Amount, Reasion, Date) VALUES (?, ?, ?, ?)");
    $insert_commission->bind_param("idss", $user_id, $bonus_amount, $reason, $joining_date);
    $insert_commission->execute();

    echo json_encode([
        'status' => 'success',
        'message' => 'User created successfully',
        'My_Reffer_Code' => $my_reffer_code
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to create account']);
}

$conn->close();
?>
