<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';
header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Validate and decrypt inputs
$transaction_id    = $requestData['id'] ?? '';
$status            = $requestData['status'] ?? '';
$user_id           = $requestData['User_ID'] ?? '';
$encrypted_amount  = $requestData['Amount'] ?? '';
$note              = $requestData['Note'] ?? '';

$conn->set_charset("utf8mb4");

if (empty($transaction_id) || empty($status) || empty($user_id) || empty($encrypted_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit();
}

$amount = decryptData($encrypted_amount);
if (empty($amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt amount']);
    exit();
}

$currentDateTime = date('Y-m-d H:i:s');
$conn->begin_transaction();

try {
    // Step 1: Update transaction status
    $stmt = $conn->prepare("UPDATE VPN_Card_Purchesh_History SET Status = ?, Details_of_Item = ? WHERE id = ?");
    $stmt->bind_param("ssi", $status, $note, $transaction_id);
    $stmt->execute();
    $stmt->close();

    // Step 2: Get user data
    $stmt = $conn->prepare("SELECT Balance, Reward, FCM_Token, Total_Spend FROM USER_DATABSE_PIN WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();

    if ($result->num_rows === 0) {
        throw new Exception("User not found");
    }

    $userData = $result->fetch_assoc();

    // 🔑 Decrypt Balance and Reward before math
    $current_balance     = !empty($userData['Balance']) ? (float) decryptSensitive($userData['Balance']) : 0.0;
    $current_reward      = !empty($userData['Reward']) ? (float) decryptSensitive($userData['Reward']) : 0.0;
    $current_total_spend = (float) $userData['Total_Spend'];
    $fcm_token           = $userData['FCM_Token'];

    // Step 3: Get app settings
    $result = $conn->query("SELECT Total_Comission_Amount, VPN_CARD_Comission_, Reward_Point_Amount, Today_Spend_Amount, Today_Comission_Amount FROM App_Setting_2 LIMIT 1");
    if ($result->num_rows === 0) {
        throw new Exception("App settings not found");
    }

    $appSettings = $result->fetch_assoc();
    $send_money_commission = (float) $appSettings['VPN_CARD_Comission_'];
    $reward_point_amount   = (float) $appSettings['Reward_Point_Amount'];

    // Step 4: Calculate commissions
    $user_commission   = ($amount * $send_money_commission) / 100;
    $user_reward       = ($amount / 1000) * $reward_point_amount;
    $new_balance       = $current_balance + $user_commission;
    $new_reward        = $current_reward + $user_reward;
    $new_total_spend   = $current_total_spend + $amount;

    // 🔒 Encrypt before saving back
    $encryptedNewBalance = encryptSensitive($new_balance);
    $encryptedNewReward  = encryptSensitive($new_reward);

    // Step 5: Update user balance and reward
    $stmt = $conn->prepare("UPDATE USER_DATABSE_PIN SET Balance = ?, Reward = ?, Total_Spend = ? WHERE id = ?");
    $stmt->bind_param("ssdi", $encryptedNewBalance, $encryptedNewReward, $new_total_spend, $user_id);
    $stmt->execute();
    $stmt->close();

    // Step 6: Log commission history
    $stmt = $conn->prepare("INSERT INTO History (User_ID, How_Much, Reasone, Date) VALUES (?, ?, ?, ?)");
    $reason = "VPN Card Buy";
    $stmt->bind_param("idss", $user_id, $user_commission, $reason, $currentDateTime);
    $stmt->execute();
    $stmt->close();

    // Step 7: (Reseller commission removed)

    // Step 8: Send FCM notification
    if (!empty($fcm_token) && strlen($fcm_token) > 50) {
        $accessToken = getAccessToken('service-account-file.json');
        $title = "VPN card purchase successful!";
        $body  = "Your VPN card purchase successful! To see details, check PTC-Telecom & Pin Shop History, you will get username, password! Thank you...";

        $payload = json_encode([
            'message' => [
                'token' => $fcm_token,
                'data' => ['title' => $title, 'body' => $body]
            ]
        ]);

        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $fcmResponse = curl_exec($ch);
        curl_close($ch);
    }

    // Step 9: Update App_Setting_2 totals
    $new_total_commission = (float) $appSettings['Total_Comission_Amount'] + $user_commission;
    $new_today_spend      = (float) $appSettings['Today_Spend_Amount'] + $amount;
    $new_today_commission = (float) $appSettings['Today_Comission_Amount'] + $user_commission;

    $stmt = $conn->prepare("UPDATE App_Setting_2 SET Total_Comission_Amount = ?, Today_Spend_Amount = ?, Today_Comission_Amount = ?");
    $stmt->bind_param("ddd", $new_total_commission, $new_today_spend, $new_today_commission);
    $stmt->execute();
    $stmt->close();

    $conn->commit();
    echo json_encode(['status' => 'success', 'message' => 'Transaction and earnings updated successfully']);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}

$conn->close();
?>