<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get user ID
    $user_id = $_POST['id'] ?? '';
    if (empty($user_id)) {
        throw new Exception('User ID is required.');
    }

    // Get user details from POST
    $first_name     = $_POST['Name1'] ?? '';
    $last_name      = $_POST['Name2'] ?? '';
    $phone_number   = $_POST['Phone_Number'] ?? '';
    $pin            = $_POST['Pin'] ?? '';
    $reward         = $_POST['Reward'] ?? '';
    $total_spend    = $_POST['Total_Spend'] ?? '';
    $total_deposit  = $_POST['Total_Deposit'] ?? '';
    $device_login   = $_POST['Device_login'] ?? '';
    $veryfi_status  = $_POST['VeryFi_status'] ?? '';
    $reffrer_code   = $_POST['Reffrer_code'] ?? '';
    $email          = $_POST['Email'] ?? '';
    $password       = $_POST['Password'] ?? '';
    $balance        = $_POST['Balance'] ?? '';
    $block          = $_POST['Block'] ?? '';

    // 🔒 Encrypt sensitive fields before update
    $encryptedPhone    = !empty($phone_number) ? encryptSensitive($phone_number) : null;
    $encryptedPIN      = !empty($pin) ? encryptSensitive($pin) : null;
    $encryptedReward   = !empty($reward) ? encryptSensitive($reward) : null;
    $encryptedEmail    = !empty($email) ? encryptSensitive($email) : null;
    $encryptedPassword = !empty($password) ? encryptSensitive($password) : null;
    $encryptedBalance  = !empty($balance) ? encryptSensitive($balance) : null;

    // Update query
    $sql = "UPDATE USER_DATABSE_PIN SET 
                Frist_Name = ?, Last_Name = ?, Phone_number = ?, PIN = ?, Reward = ?, 
                Total_Spend = ?, Total_Deposit = ?, Device_login = ?, Veryfi_Status = ?, 
                My_Reffer_Code = ?, Email = ?, User_Password = ?, Balance = ?, Block = ? 
            WHERE id = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception('Failed to prepare SQL statement: ' . $conn->error);
    }

    $stmt->bind_param(
        "ssssssssssssssi",
        $first_name,
        $last_name,
        $encryptedPhone,
        $encryptedPIN,
        $encryptedReward,
        $total_spend,
        $total_deposit,
        $device_login,
        $veryfi_status,
        $reffrer_code,
        $encryptedEmail,
        $encryptedPassword,
        $encryptedBalance,
        $block,
        $user_id
    );

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'User details updated successfully.']);
    } else {
        throw new Exception('Failed to update user details.');
    }

    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>