<?php
// Include connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debugging log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate and Decrypt Inputs
$transaction_id    = $requestData['id'] ?? '';
$status            = $requestData['status'] ?? '';
$user_id           = $requestData['User_ID'] ?? '';
$encrypted_amount  = $requestData['Amount'] ?? '';
$note              = $requestData['Note'] ?? '';

$conn->set_charset("utf8mb4");

if (empty($transaction_id) || empty($status) || empty($user_id) || empty($encrypted_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit();
}

// Decrypt values
$amount = decryptData($encrypted_amount);

if (empty($user_id) || empty($amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt necessary data']);
    exit();
}

// Step 3: Update `Status` in `Bank_Request_history`
$updateStatusSql = "UPDATE Bank_Request_history SET Status = ?, Note = ? WHERE id = ?";
$stmtUpdateStatus = $conn->prepare($updateStatusSql);
$stmtUpdateStatus->bind_param("ssi", $status, $note, $transaction_id);

if (!$stmtUpdateStatus->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update transaction status']);
    exit();
}
$stmtUpdateStatus->close();

// Step 4: Get Current User Balance and Reward
$userDataSql = "SELECT Balance, Reward, FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
$stmtUserData = $conn->prepare($userDataSql);
$stmtUserData->bind_param("i", $user_id);
$stmtUserData->execute();
$resultUserData = $stmtUserData->get_result();
$stmtUserData->close();

if ($resultUserData->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'User not found']);
    exit();
}

$userData = $resultUserData->fetch_assoc();

// 🔑 Decrypt balance and reward before math
$current_balance = !empty($userData['Balance']) ? (float) decryptSensitive($userData['Balance']) : 0.0;
$current_reward  = !empty($userData['Reward']) ? (float) decryptSensitive($userData['Reward']) : 0.0;
$fcm_token       = $userData['FCM_Token'];

// Step 5: Get Commission & Reward Percentages from `App_Setting_2`
$appSettingsSql = "SELECT Bank_money_Comission, Reward_Point_Amount FROM App_Setting_2 LIMIT 1";
$resultAppSettings = $conn->query($appSettingsSql);

if ($resultAppSettings->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found']);
    exit();
}

$appSettings = $resultAppSettings->fetch_assoc();
$send_money_commission = (float) $appSettings['Bank_money_Comission']; 
$reward_point_amount   = (float) $appSettings['Reward_Point_Amount'];

// Step 6: Calculate User Earnings
$user_commission = ($amount * $send_money_commission) / 100;
$new_balance     = $current_balance + $user_commission;

$user_reward     = ($amount / 1000) * $reward_point_amount;
$new_reward      = $current_reward + $user_reward;

// 🔒 Encrypt before saving
$encryptedNewBalance = encryptSensitive($new_balance);
$encryptedNewReward  = encryptSensitive($new_reward);

// Step 7: Update User Balance & Reward
$updateUserSql = "UPDATE USER_DATABSE_PIN SET Balance = ?, Reward = ? WHERE id = ?";
$stmtUpdateUser = $conn->prepare($updateUserSql);
$stmtUpdateUser->bind_param("ssi", $encryptedNewBalance, $encryptedNewReward, $user_id);

if (!$stmtUpdateUser->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update user balance']);
    exit();
}
$stmtUpdateUser->close();

// Step 7.1: Insert User Commission Record into History
$historyInsertSql = "INSERT INTO History (User_ID, How_Much, Reasone, Date) VALUES (?, ?, ?, ?)";
$stmtHistory = $conn->prepare($historyInsertSql);

$reasone = "Bank Money";
$currentDateTime = date('Y-m-d H:i:s');

$stmtHistory->bind_param("idss", $user_id, $user_commission, $reasone, $currentDateTime);

if (!$stmtHistory->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to log commission in history']);
    exit();
}
$stmtHistory->close();

// Step 7.2: Update User's Total_Spend
$totalSpendSql = "SELECT Total_Spend FROM USER_DATABSE_PIN WHERE id = ?";
$stmtTotalSpend = $conn->prepare($totalSpendSql);
$stmtTotalSpend->bind_param("i", $user_id);
$stmtTotalSpend->execute();
$resultTotalSpend = $stmtTotalSpend->get_result();
$stmtTotalSpend->close();

if ($resultTotalSpend->num_rows > 0) {
    $userSpendData = $resultTotalSpend->fetch_assoc();
    $current_total_spend = (float) $userSpendData['Total_Spend'];
    $new_total_spend     = $current_total_spend + $amount;

    $updateSpendSql = "UPDATE USER_DATABSE_PIN SET Total_Spend = ? WHERE id = ?";
    $stmtUpdateSpend = $conn->prepare($updateSpendSql);
    $stmtUpdateSpend->bind_param("di", $new_total_spend, $user_id);

    if (!$stmtUpdateSpend->execute()) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update Total_Spend']);
        exit();
    }
    $stmtUpdateSpend->close();
}

// Step 8: (Reseller commission removed)

// Step 9: Return Success Response
echo json_encode(['status' => 'success', 'message' => 'Transaction and earnings updated successfully']);

//********************************************************
// Send FCM notification
if (!empty($fcm_token) && strlen($fcm_token) > 100) {
    $accessToken = getAccessToken('service-account-file.json');

    $title = "Bank transfer successful! ";
    $body  = "Your bank money request of " . number_format($amount, 2) . " taka has been successful! Thank you...";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        error_log("FCM Send Error: " . curl_error($ch));
    } else {
        error_log("FCM Response: " . $fcmResponse);
    }
    curl_close($ch);
}
//**************************************

// Step 10: Retrieve Existing Totals from `App_Setting_2`
$appSettings2Sql = "SELECT Total_Comission_Amount, Today_Spend_Amount, Today_Comission_Amount FROM App_Setting_2 LIMIT 1";
$resultAppSettings2 = $conn->query($appSettings2Sql);

if ($resultAppSettings2->num_rows == 0) {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found in App_Setting_2.']);
    exit();
}

$appSettings2 = $resultAppSettings2->fetch_assoc();
$current_total_commission = (float) $appSettings2['Total_Comission_Amount'];
$current_today_spend = (float) $appSettings2['Today_Spend_Amount'];
$current_today_commission = (float) $appSettings2['Today_Comission_Amount'];

// Step 11: Update Totals in `App_Setting_2`
$new_total_commission = $current_total_commission + $user_commission;
$new_today_spend = $current_today_spend + $amount;
$new_today_commission = $current_today_commission + $user_commission;

$updateAppSettings2Sql = "UPDATE App_Setting_2 SET Total_Comission_Amount = ?, Today_Spend_Amount = ?, Today_Comission_Amount = ?";
$stmtUpdateAppSettings2 = $conn->prepare($updateAppSettings2Sql);
$stmtUpdateAppSettings2->bind_param("ddd", $new_total_commission, $new_today_spend, $new_today_commission);

if (!$stmtUpdateAppSettings2->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update commission and spend data']);
    exit();
}

$stmtUpdateAppSettings2->close();



$conn->close();
?>