<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';

// Encryption helpers (Database encryption)
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

require 'get-access-token.php';

try {
    $input = json_decode(file_get_contents('php://input'), true);

    $api_key        = $input['api_key'] ?? '';
    $transaction_id = $input['id'] ?? '';
    $user_id        = $input['User_ID'] ?? '';
    $status         = $input['status'] ?? '';
    $encrypted_amount = $input['Amount'] ?? '';

    $conn->set_charset("utf8mb4");

    // Validate API Key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // -----------------------------
    // 1️⃣ Decrypt AMOUNT (Android)
    // -----------------------------
    $amount = decryptData($encrypted_amount);  // THIS IS CORRECT

    if (!is_numeric($amount) || $amount <= 0) {
        throw new Exception("Invalid amount.");
    }

    // -----------------------------
    // Fetch User Details
    // -----------------------------
    $sql = "SELECT Balance, Total_Deposit, Reward, FCM_Token 
            FROM USER_DATABSE_PIN 
            WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $stmt->close();

    if ($res->num_rows == 0) {
        throw new Exception("User not found");
    }

    $userData = $res->fetch_assoc();

    // -----------------------------
    // 2️⃣ Decrypt BALANCE & REWARD
    // -----------------------------
    $current_balance = decryptSensitive($userData['Balance']);
    $current_reward  = decryptSensitive($userData['Reward']);

    if (!is_numeric($current_balance)) $current_balance = 0;
    if (!is_numeric($current_reward))  $current_reward  = 0;

    // -----------------------------
    // Add new amount
    // -----------------------------
    $newBalance = $current_balance + $amount;
    $newReward  = $current_reward + $amount;

    // Total_Deposit (NOT encrypted)
    $newDeposit = floatval($userData['Total_Deposit']) + $amount;

    // -----------------------------
    // 3️⃣ Re-encrypt BALANCE & REWARD
    // -----------------------------
    $encrypted_new_balance = encryptSensitive($newBalance);
    $encrypted_new_reward  = encryptSensitive($newReward);

    // -----------------------------
    // Update user
    // -----------------------------
    $updateUser = "UPDATE USER_DATABSE_PIN 
                   SET Balance = ?, Total_Deposit = ?, Reward = ?
                   WHERE id = ?";
    $stmt = $conn->prepare($updateUser);
    $stmt->bind_param("sdss",
        $encrypted_new_balance,
        $newDeposit,
        $encrypted_new_reward,
        $user_id
    );
    $stmt->execute();
    $stmt->close();

    // -----------------------------
    // Update transaction status
    // -----------------------------
    $updateTxn = "UPDATE Add_Money_History SET Status = ? WHERE id = ?";
    $stmt2 = $conn->prepare($updateTxn);
    $stmt2->bind_param("si", $status, $transaction_id);
    $stmt2->execute();
    $stmt2->close();

    // -----------------------------
    // Update Today_Total_Deposit_Amount
    // -----------------------------
    $app = $conn->query("SELECT Today_Total_Deposit_Amount FROM App_Setting_2 LIMIT 1");

    if ($app && $app->num_rows > 0) {
        $row = $app->fetch_assoc();
        $updatedAppDeposit = floatval($row['Today_Total_Deposit_Amount']) + $amount;

        $stmt3 = $conn->prepare("UPDATE App_Setting_2 SET Today_Total_Deposit_Amount = ?");
        $stmt3->bind_param("d", $updatedAppDeposit);
        $stmt3->execute();
        $stmt3->close();
    }

    // -----------------------------
    // Send FCM Notification
    // -----------------------------
    $fcm_token = $userData['FCM_Token'];
    
// Step 9: Send FCM notification (optional)
if (!empty($fcm_token) && strlen($fcm_token) > 100) {
    $accessToken = getAccessToken('service-account-file.json');

 $title = "New balance added to your account!";
    $body  = "৳" . number_format($amount, 2) . " successfully added to balance!.Current total balance:৳" . number_format($newBalance, 2)." Taka";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        error_log("FCM Send Error: " . curl_error($ch));
    } else {
        error_log("FCM Response: " . $fcmResponse);
    }
    curl_close($ch);
}

// Step 10: Return Success Response
echo json_encode(['status' => 'success', 'message' => 'Transaction and earnings updated successfully']);


} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    $conn->close();
}
?>
