<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {

    // ✅ Get inputs
    $id   = $_POST['id'] ?? '';
    $rate = $_POST['Rate'] ?? '';

    if (empty($id) || empty($rate)) {
        throw new Exception('ID and Rate are required.');
    }

    // ✅ Correct SQL
    $sql = "UPDATE Exchnage_Rate SET Today_Rate = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);

    // ✅ Correct bind order (rate FIRST, id SECOND)
    $stmt->bind_param("di", $rate, $id);

    if ($stmt->execute()) {

        if ($stmt->affected_rows > 0) {
            echo json_encode([
                'status'  => 'success',
                'message' => 'Today rate updated successfully.'
            ]);
        } else {
            echo json_encode([
                'status'  => 'error',
                'message' => 'No row updated. Invalid ID?'
            ]);
        }

    } else {
        throw new Exception('Failed to update rate.');
    }

    $stmt->close();

} catch (Exception $e) {
    echo json_encode([
        'status'  => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>
