<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Collect and sanitize inputs
    $user_id = $_POST['id'] ?? '';
    $title = $_POST['title'] ?? '';
    $price = $_POST['price'] ?? '';
    $offprice = $_POST['offprice'] ?? '';
    $details = $_POST['details'] ?? '';

    if (empty($user_id)) {
        throw new Exception('User ID is required.');
    }

    // Prepare SQL statement
    $sql = "UPDATE Scratch_PIN 
            SET Title = ?, Price = ?, Price_OFF = ?, Details = ?
            WHERE id = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception('Failed to prepare SQL statement: ' . $conn->error);
    }

    // Bind parameters in correct order
    $stmt->bind_param("ssssi", $title, $price, $offprice, $details, $user_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Details updated successfully.']);
    } else {
        throw new Exception('Failed to update record: ' . $stmt->error);
    }

    $stmt->close();
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
