<?php
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

// Read and decode JSON input
$requestData = json_decode(file_get_contents("php://input"), true);
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    $conn->close();
    exit();
}

// Extract and validate required fields
$transaction_id = $requestData['id'] ?? '';
$status = $requestData['status'] ?? '';
$user_id = $requestData['User_ID'] ?? '';
$encrypted_amount = $requestData['Amount'] ?? '';

if (empty($transaction_id) || empty($status) || empty($user_id) || empty($encrypted_amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    $conn->close();
    exit();
}

// Decrypt amount
$amount = decryptData($encrypted_amount);
if (empty($amount)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt amount']);
    $conn->close();
    exit();
}

// Fetch FCM token
$userDataSql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
$stmtUserData = $conn->prepare($userDataSql);
$stmtUserData->bind_param("i", $user_id);
$stmtUserData->execute();
$resultUserData = $stmtUserData->get_result();
$userData = $resultUserData->fetch_assoc();
$stmtUserData->close();

if (!$userData || strlen($userData['FCM_Token']) < 100) {
    error_log("Invalid or missing FCM token for user ID: $user_id");
    echo json_encode(['status' => 'error', 'message' => 'FCM token not found or invalid']);
    $conn->close();
    exit();
}

$fcm_token = $userData['FCM_Token'];

// Update transaction status
$updateStatusSql = "UPDATE Reward_Recharge_Request SET Status = ? WHERE id = ?";
$stmtUpdateStatus = $conn->prepare($updateStatusSql);
$stmtUpdateStatus->bind_param("si", $status, $transaction_id);

if (!$stmtUpdateStatus->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to update transaction status']);
    $stmtUpdateStatus->close();
    $conn->close();
    exit();
}
$stmtUpdateStatus->close();

// Send FCM notification

// Step 9: Send FCM notification (optional)
if (!empty($fcm_token) && strlen($fcm_token) > 100) {
    $accessToken = getAccessToken('service-account-file.json');

    $title = "Reward Mobile Recharge Successful!";
    $body  = "Your ৳" . number_format($amount, 2) . " taka Reward recharge has been successful! Thank you?.";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        error_log("FCM Send Error: " . curl_error($ch));
    } else {
        error_log("FCM Response: " . $fcmResponse);
    }
    curl_close($ch);
}

// Step 10: Return Success Response
echo json_encode(['status' => 'success', 'message' => 'Transaction and earnings updated successfully']);
$conn->close();
?>