<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    date_default_timezone_set('Asia/Dhaka');

    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Validate and decrypt `Phone_Number`
    $encryptedPhone = $_POST['Phone_Num'] ?? '';
    if (empty($encryptedPhone)) {
        throw new Exception('Phone number is required.');
    }

    $phoneNumber = decryptData($encryptedPhone);
    if (empty($phoneNumber)) {
        throw new Exception('Failed to decrypt phone number.');
    }

    // Fetch all users (because Phone_number is encrypted in DB)
    $sql = "SELECT id, Frist_Name, Last_Name, Email, Phone_number, PIN, User_Password, Balance,
                   My_Reffer_Code, Who_invite_reffer_code, Joining_date, Veryfi_Status, Total_Deposit,
                   Total_Spend, FCM_Token, Selfi_photo, Nid_Front, Nid_Back, Block, Device_login,
                   Reward, Ban_From_Add_money 
            FROM USER_DATABSE_PIN";

    $result = $conn->query($sql);
    if ($result->num_rows == 0) {
        throw new Exception('No user data found.');
    }

    $users = [];
    $found = false;

    while ($row = $result->fetch_assoc()) {
        // 🔑 Decrypt stored phone number
        $decryptedPhone = !empty($row['Phone_number']) ? decryptSensitive($row['Phone_number']) : null;

        if (trim($decryptedPhone) === trim($phoneNumber)) {
            // Decrypt other sensitive fields
            $decryptedEmail    = !empty($row['Email']) ? decryptSensitive($row['Email']) : null;
            $decryptedPIN      = !empty($row['PIN']) ? decryptSensitive($row['PIN']) : null;
            $decryptedPassword = !empty($row['User_Password']) ? decryptSensitive($row['User_Password']) : null;
            $decryptedBalance  = !empty($row['Balance']) ? (float) decryptSensitive($row['Balance']) : 0.0;
            $decryptedReward   = !empty($row['Reward']) ? (float) decryptSensitive($row['Reward']) : 0.0;

            $users[] = [
                'id'                 => $row['id'],
                'Frist_Name'         => $row['Frist_Name'],
                'Last_Name'          => $row['Last_Name'],
                'Email'              => $decryptedEmail,
                'Phone_number'       => $decryptedPhone,
                'PIN'                => $decryptedPIN,
                'User_Password'      => $decryptedPassword,
                'Balance'            => number_format($decryptedBalance, 2, '.', ''),
                'My_Reffer_Code'     => $row['My_Reffer_Code'],
                'Who_invite_reffer_code' => $row['Who_invite_reffer_code'],
                'Joining_date'       => $row['Joining_date'],
                'Veryfi_Status'      => $row['Veryfi_Status'],
                'Total_Deposit'      => $row['Total_Deposit'],
                'Total_Spend'        => $row['Total_Spend'],
                'FCM_Token'          => $row['FCM_Token'],
                'Selfi_photo'        => $row['Selfi_photo'],
                'Nid_Front'          => $row['Nid_Front'],
                'Nid_Back'           => $row['Nid_Back'],
                'Block'              => $row['Block'],
                'Device_login'       => $row['Device_login'],
                'Reward'             => number_format($decryptedReward, 2, '.', ''),
                'Ban_From_Add_money' => $row['Ban_From_Add_money']
            ];

            $found = true;
            break; // stop once we’ve found the matching user
        }
    }

    if ($found) {
        echo json_encode(["status" => "success", "data" => $users]);
    } else {
        echo json_encode(["status" => "error", "message" => "User not found"]);
    }

} catch (Exception $e) {
    echo json_encode([
        "status"  => "error",
        "message" => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>