<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

require 'get-access-token.php';
try {
    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get IDs and image data
    $nid_id = $_POST['id'] ?? '';
    $user_id = $_POST['user_id'] ?? '';
    $selfi_photo = $_POST['selfi_'] ?? '';
    $nid_front = $_POST['front_image'] ?? '';
    $nid_back = $_POST['back_image'] ?? '';

    if (empty($nid_id) || empty($user_id) || empty($selfi_photo) || empty($nid_front) || empty($nid_back)) {
        throw new Exception('NID request ID, user ID, and images are required.');
    }
    
    
    // Fetch user data
    $userSql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtUser = $conn->prepare($userSql);
    $stmtUser->bind_param("s", $user_id);
    $stmtUser->execute();
    $resultUser = $stmtUser->get_result();
    $stmtUser->close();
    
    

    if ($resultUser->num_rows === 0) {
        throw new Exception("User not found.");
    }
     $userData = $resultUser->fetch_assoc();

     

    // Step 2: Update `Veryfi_Status`, `Selfi_photo`, `Nid_Front`, `Nid_Back` in `User_Database`
    $updateUserSql = "UPDATE USER_DATABSE_PIN SET Veryfi_Status = 1, Selfi_photo = ?, Nid_Front = ?, Nid_Back = ? WHERE id = ?";
    $stmtUser = $conn->prepare($updateUserSql);
    $stmtUser->bind_param("ssss", $selfi_photo, $nid_front, $nid_back, $user_id);

    if (!$stmtUser->execute()) {
        throw new Exception('Failed to update user verification details.');
    }
    $stmtUser->close();

    // Return success response
    echo json_encode(['status' => 'success', 'message' => 'NID verification updated successfully.']);
    
    // Step 3: Delete the NID_Verify_Request row after successful verification
$deleteNidSql = "DELETE FROM NID_Verify_Request WHERE id = ?";
$stmtDeleteNid = $conn->prepare($deleteNidSql);
$stmtDeleteNid->bind_param("s", $nid_id);

if (!$stmtDeleteNid->execute()) {
    throw new Exception('Failed to delete NID verification request.');
}
$stmtDeleteNid->close();
    
    
    
    //********************************************************
    // Get FCM token from User_Database
    $getFcmSql = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtFcm = $conn->prepare($getFcmSql);
    $stmtFcm->bind_param("i", $user_id);
    $stmtFcm->execute();
    $resultFcm = $stmtFcm->get_result();
    if ($resultFcm->num_rows === 0) {
        throw new Exception('FCM token not found for user.');
    }
    $user = $resultFcm->fetch_assoc();
    $fcm_token = $user['FCM_Token'];
    $stmtFcm->close();

 // Send FCM notification

    if (strlen($fcm_token) < 100) {
        throw new Exception("Invalid FCM token.");
    }

    $accessToken = getAccessToken('service-account-file.json');

    $title = "NID Verify Confirmed! ";
    $body = "Your account has been verified, from now on you can fully use PTC-Telecom & Pin Shop. Thank you...";

    $datamsg = ['title' => $title, 'body' => $body];
    $payload = json_encode(['message' => ['token' => $fcm_token, 'data' => $datamsg]]);

    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $fcmResponse = curl_exec($ch);
    if ($fcmResponse === FALSE) {
        throw new Exception("FCM Send Error: " . curl_error($ch));
    }
    curl_close($ch);
//**************************************
    

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
