<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';  // Include the file to get FCM access token

try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get User_ID and Message
    $user_id = $input['User_ID'] ?? '';
    $message = $input['Massage'] ?? '';
    
    $conn->set_charset("utf8mb4");

    if (empty($user_id) || empty($message)) {
        throw new Exception('User ID and message are required.');
    }

    // Retrieve FCM token for the user
    $tokenQuery = "SELECT FCM_Token FROM USER_DATABSE_PIN WHERE id = ?";
    $stmtToken = $conn->prepare($tokenQuery);
    $stmtToken->bind_param("s", $user_id);
    $stmtToken->execute();
    $resultToken = $stmtToken->get_result();
    $stmtToken->close();

    if ($resultToken->num_rows == 0) {
        throw new Exception('FCM token not found for the user.');
    }

    $userData = $resultToken->fetch_assoc();
    $fcm_token = $userData['FCM_Token'];

    // Validate FCM token format
    if (strlen($fcm_token) < 100) {
        throw new Exception('Invalid FCM token.');
    }

    // Get Bearer Token
    $accessToken = getAccessToken('service-account-file.json');

    // FCM message
    $title = "PTC-Telecom & PIN SHop";
    $body = $message;  // Message content from request

    $datamsg = array(
        'title' => $title,
        'body' => $body
    );

    // FCM payload
    $arrayToSend = array('token' => $fcm_token, 'data' => $datamsg);
    $json = json_encode(['message' => $arrayToSend]);

    // Headers
    $headers = array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken
    );

    // cURL setup
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    // Check for errors
    if ($response === FALSE) {
        throw new Exception("FCM Send Error: " . curl_error($ch));
    }

    curl_close($ch);

    echo json_encode(["status" => "success", "message" => "Notification sent successfully"]);

} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    $conn->close();
}
