<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');
require 'get-access-token.php';

try {
    // Read incoming JSON
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate API key
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    $message = trim($input['Massage'] ?? '');
    $conn->set_charset("utf8mb4");

    if (empty($message)) {
        throw new Exception('Message content is required.');
    }

    // Get Bearer token once
    $accessToken = getAccessToken('service-account-file.json');

    // Prepare FCM payload
    $title = "PTC-Telecom & PIN SHop";
    $datamsg = array("title" => $title, "body" => $message);

    // Fetch all valid FCM tokens
    $tokenQuery = "SELECT DISTINCT FCM_Token FROM USER_DATABSE_PIN WHERE FCM_Token IS NOT NULL AND FCM_Token != '' AND FCM_Token != '0'";

    $result = $conn->query($tokenQuery);

    if ($result->num_rows === 0) {
        throw new Exception('No valid FCM tokens found.');
    }

    $sendCount = 0;
    while ($row = $result->fetch_assoc()) {
        $fcm_token = $row['FCM_Token'];
        if (strlen($fcm_token) < 100) continue; // Skip invalid tokens

        $arrayToSend = [
            "token" => $fcm_token,
            "data"  => $datamsg
        ];

        $payload = json_encode(["message" => $arrayToSend]);

        // Send FCM request
        $headers = [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $accessToken
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/pinshop-96581/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        curl_close($ch);

        if ($response !== false) {
            $sendCount++;
        }
    }

    echo json_encode([
        "status"  => "success",
        "message" => "Notification sent to {$sendCount} user(s)."
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status"  => "error",
        "message" => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
