<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debug log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate and Decrypt Input Data
$encrypted_offer = $requestData['Offer'] ?? '';
$encrypted_amount_offer = $requestData['Amount_offer'] ?? '';
$encrypted_commission_amount = $requestData['Comission_amount'] ?? '';
$encrypted_operator = $requestData['Oparator'] ?? '';
$encrypted_type = $requestData['Type'] ?? '';

if (empty($encrypted_offer) || empty($encrypted_amount_offer) || empty($encrypted_commission_amount) || empty($encrypted_operator) || empty($encrypted_type)) {
    echo json_encode(['status' => 'error', 'message' => 'All fields are required']);
    exit();
}

// Decrypt values
$offer = decryptData($encrypted_offer);
$amount_offer = decryptData($encrypted_amount_offer);
$commission_amount = decryptData($encrypted_commission_amount);
$operator = decryptData($encrypted_operator);
$type = decryptData($encrypted_type);

if (empty($offer) || empty($amount_offer) || empty($commission_amount) || empty($operator) || empty($type)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt necessary data']);
    exit();
}
$conn->set_charset("utf8mb4");

// Step 3: Insert Data into `Drive_Offer` Table
$insertOfferSql = "INSERT INTO Drive_Offer (Offer_Text, Amount_Offer, Comission_Amount, Oparator, Type) VALUES (?, ?, ?, ?, ?)";
$stmtInsertOffer = $conn->prepare($insertOfferSql);
$stmtInsertOffer->bind_param("sssss", $offer, $amount_offer, $commission_amount, $operator, $type);

if ($stmtInsertOffer->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Offer added successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to add offer']);
}

// Close connections
$stmtInsertOffer->close();
$conn->close();
?>
