<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';

// Encryption + Decryption Helpers
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Read JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Step 1: Validate API Key
    $validation = validateApiKey($input['api_key'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Step 2: Validate User ID
    $user_id = $input['id'] ?? '';
    if (empty($user_id)) {
        throw new Exception('User ID is required.');
    }

    // Decrypt user ID
 
    if (empty($user_id)) {
        throw new Exception('Failed to decrypt User ID.');
    }

    // Step 3: SQL query
    $sql = "SELECT id, Frist_Name, Last_Name, Email, Phone_number, PIN, User_Password, Balance, 
                   My_Reffer_Code, Who_invite_reffer_code, Joining_date, Veryfi_Status, 
                   Total_Deposit, Total_Spend, FCM_Token, Selfi_photo, Nid_Front,Nid_Back, Block, Device_login, Reward, Ban_From_Add_money
            FROM USER_DATABSE_PIN WHERE id = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        throw new Exception('User not found.');
    }

    $userData = $result->fetch_assoc();

    // -------------------------------------
    // 🔐 DECRYPT ENCRYPTED FIELDS
    // -------------------------------------

    if (!empty($userData['PIN'])) {
        $userData['PIN'] = decryptData($userData['PIN']);
    }

    if (!empty($userData['User_Password'])) {
        $userData['User_Password'] = decryptData($userData['User_Password']);
    }

    if (!empty($userData['Balance'])) {
        $userData['Balance'] = decryptData($userData['Balance']);
    }

    if (!empty($userData['Phone_number'])) {
        $userData['Phone_number'] = decryptData($userData['Phone_number']);
    }

    // Return final JSON
    echo json_encode(['status' => 'success', 'data' => $userData]);

} catch (Exception $e) {

    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    
} finally {
    $conn->close();
}
?>
