<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');   // contains SENSITIVE_KEY
require_once('/home/akashpyc/private/encryption_helper.php'); // has encryptSensitive/decryptSensitive

try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['API__K_E_Y'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    date_default_timezone_set('Asia/Dhaka');

    // Validate and decrypt `Phone_Number`
    $encryptedPhone = $input['Phone_Number'] ?? '';
    if (empty($encryptedPhone)) {
        throw new Exception('Phone number is required.');
    }

    $phoneNumber = decryptData($encryptedPhone);
    if (empty($phoneNumber)) {
        throw new Exception('Failed to decrypt phone number.');
    }

    // 🔒 Encrypt again to match DB storage
    $encryptedPhoneForDb = encryptSensitive($phoneNumber);

    // SQL query to fetch data for the given phone number (stored encrypted)
    $sql = "SELECT id, Phone_number, Ban_From_Add_money
            FROM USER_DATABSE_PIN
            WHERE Phone_number = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $encryptedPhoneForDb);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        // 🔑 Decrypt phone number before returning
        $row['Phone_number'] = !empty($row['Phone_number'])
            ? decryptSensitive($row['Phone_number'])
            : null;

        $data[] = $row;
    }

    // Return success JSON
    echo json_encode(['status' => 'success', 'data' => $data]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}
?>