<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');


try {
    // Read the raw JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Validate the API key from JSON input
    $validation = validateApiKey($input['API__K_E_Y'] ?? null);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    date_default_timezone_set('Asia/Dhaka');

    // Validate and decrypt `Phone_Number`
    $encryptedPhone = $input['Phone_Number'] ?? '';

    if (empty($encryptedPhone)) {
        throw new Exception('Phone number is required.');
    }

    $phoneNumber = decryptData($encryptedPhone);
    if (empty($phoneNumber)) {
        throw new Exception('Failed to decrypt phone number.');
    }

    // SQL query to fetch data for the given phone number
    $sql = "SELECT id, User_ID, Phone_number, Amount, USDT, Methode, Date, Status, Trx_ID, Contact_number, Bianace_Id_gmail  
            FROM Add_Money_History 
            WHERE Phone_number = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $phoneNumber);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result === false) {
        throw new Exception($conn->error);
    }

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    // Return success JSON
    echo json_encode(['status' => 'success', 'data' => $data]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}