<?php
// Include database connection and validation files
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid JSON format']);
    exit();
}

// Debugging log for received JSON request
error_log("Raw JSON Data Received: " . json_encode($requestData));

// Step 1: Validate API key
$apiKeyValidation = validateApiKey($requestData['API__K_E_Y'] ?? null);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 2: Validate and Decrypt Operator Name
$encrypted_operator = $requestData['Oparatror'] ?? '';
if (empty($encrypted_operator)) {
    echo json_encode(['status' => 'error', 'message' => 'Operator name is required']);
    exit();
}

$operator = decryptData($encrypted_operator);
if (empty($operator)) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to decrypt operator name']);
    exit();
}

// Step 3: Fetch Offers by Operator
$offerQuery = "SELECT id, Offer_Text, Amount_Offer, Comission_Amount, Oparator, Type FROM Drive_Offer WHERE Oparator = ?";
$stmtOffer = $conn->prepare($offerQuery);
$stmtOffer->bind_param("s", $operator);
$stmtOffer->execute();
$resultOffers = $stmtOffer->get_result();
$stmtOffer->close();

// Step 4: Format and Return JSON Response
$offers = [];
while ($row = $resultOffers->fetch_assoc()) {
    $offers[] = $row;
}

if (!empty($offers)) {
    echo json_encode(['status' => 'success', 'data' => $offers]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No offers found for this operator']);
}

$conn->close();
?>
