<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Validate API key from form-data ($_POST)
    $api_key = $_POST['api_key'] ?? null;
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Get VPN Card ID
    $vpn_id = $_POST['id'] ?? '';
    if (empty($vpn_id)) {
        throw new Exception('VPN Card ID is required.');
    }

    // Fetch VPN Card Details
    $sql = "SELECT id, Title, Price, Price_OFF, Link, User_Name, Pasword, VPN_APP_link, Details, Image FROM Dollar_Card WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $vpn_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        throw new Exception('VPN card not found.');
    }

    $vpnData = $result->fetch_assoc();

    // Return success JSON with VPN card details
    echo json_encode(['status' => 'success', 'data' => $vpnData]);

} catch (Exception $e) {
    // Return error JSON
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
} finally {
    $conn->close();
}