<?php
// Include DB connection and decryption files
include 'connection.php';
include 'decryption_api_key.php';

header('Content-Type: application/json');
date_default_timezone_set('Asia/Dhaka');

// Read JSON POST data
$requestData = json_decode(file_get_contents("php://input"), true);

// Step 1: Check for API key
if (!isset($requestData['api_key'])) {
    echo json_encode(['status' => 'error', 'message' => 'API key missing']);
    exit();
}

// Step 2: Validate API key
$apiKeyValidation = validateApiKey($requestData['api_key']);
if (!$apiKeyValidation['status']) {
    echo json_encode(['status' => 'error', 'message' => $apiKeyValidation['message']]);
    exit();
}

// Step 3: Fetch all App_Setting fields
$sql = "SELECT 
    id, Today_Dollar_Rate
FROM Binance_add_money_details
LIMIT 1";

$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    $settings = $result->fetch_assoc();
    echo json_encode([
        'status' => 'success',
        'message' => 'Settings fetched successfully',
        'data' => $settings
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'App settings not found']);
}

$conn->close();
?>
