<?php
header('Content-Type: application/json; charset=utf-8');
include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // --- Basic Auth ---
    if (!isset($_SERVER['PHP_AUTH_USER'])) {
        throw new Exception("Unauthorized request");
    }

    $valid_user = "otp_send_cheack_512";
    $valid_pass = "Jp4{+82F5Tf-";

    if ($_SERVER['PHP_AUTH_USER'] !== $valid_user || $_SERVER['PHP_AUTH_PW'] !== $valid_pass) {
        throw new Exception("Invalid credentials");
    }

    // --- Read API Key from POST params ---
    if (!isset($_POST['api_key'])) {
        throw new Exception("API Key missing in request");
    }

    $api_key = $_POST['api_key'];

    // --- API Key Validation ---
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // --- Fetch App_Setting_2 Data ---
    $sql = "SELECT 
                Total_Bonus_Amount,
                Total_Comission_Amount,
                Today_Spend_Amount,
                Today_Comission_Amount,
                Today_Total_Deposit_Amount,
                Today_Total_Bonus_Amount,
                Total_Reffer_Comission_Amount,
                Today_Reffer_Comission_Amount
            FROM App_Setting_2 
            LIMIT 1";

    $result = $conn->query($sql);
    $data = [];

    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_assoc();
    } else {
        throw new Exception("No data found in App_Setting_2");
    }

    // --- Fetch USER_DATABSE_PIN Data and decrypt balances ---
    $userSql = "SELECT Balance, Total_Deposit FROM USER_DATABSE_PIN";
    $userResult = $conn->query($userSql);

    $totalAmount  = 0.0;
    $totalDeposit = 0.0;

    if ($userResult && $userResult->num_rows > 0) {
        while ($row = $userResult->fetch_assoc()) {
            // Decrypt Balance before summing
            $decryptedBalance = !empty($row['Balance']) ? (float) decryptSensitive($row['Balance']) : 0.0;
            $totalAmount += $decryptedBalance;

            // Total_Deposit assumed not encrypted
            $totalDeposit += (float) $row['Total_Deposit'];
        }
    }

    $data['Total_Amount']  = $totalAmount;
    $data['Total_Deposit'] = $totalDeposit;

    // --- Replace nulls with "0" ---
    foreach ($data as $key => $value) {
        if (is_null($value)) {
            $data[$key] = "0";
        }
    }

    echo json_encode([
        "status" => "success",
        "data"   => $data
    ], JSON_UNESCAPED_UNICODE);

    $conn->close();

} catch (Exception $e) {
    echo json_encode([
        "status"  => "error",
        "message" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>