<?php
header('Content-Type: application/json; charset=utf-8');

include 'connection.php';
include 'decryption_api_key.php';
require_once('/home/akashpyc/private/privet_key.php');
require_once('/home/akashpyc/private/encryption_helper.php');

try {
    // Read POST data (not JSON)
    $api_key = $_POST['api_key'] ?? '';

    // Validate API key
    $validation = validateApiKey($api_key);
    if (!$validation['status']) {
        throw new Exception($validation['message']);
    }

    // Query all users
    $sql = "SELECT id, Frist_Name, Last_Name, Email, Phone_number, PIN, User_Password, Balance,
                   My_Reffer_Code, Who_invite_reffer_code, Joining_date, Veryfi_Status, Total_Deposit,
                   Total_Spend, FCM_Token, Selfi_photo, Nid_Front, Nid_Back, Block, Device_login,
                   Reward, Ban_From_Add_money 
            FROM USER_DATABSE_PIN";

    $result = $conn->query($sql);
    if ($result->num_rows === 0) {
        throw new Exception("No user data found.");
    }

    $users = [];
    while ($row = $result->fetch_assoc()) {
        // 🔑 Decrypt sensitive fields
        $decryptedEmail    = !empty($row['Email']) ? decryptSensitive($row['Email']) : null;
        $decryptedPhone    = !empty($row['Phone_number']) ? decryptSensitive($row['Phone_number']) : null;
        $decryptedPIN      = !empty($row['PIN']) ? decryptSensitive($row['PIN']) : null;
        $decryptedPassword = !empty($row['User_Password']) ? decryptSensitive($row['User_Password']) : null;
        $decryptedBalance  = !empty($row['Balance']) ? (float) decryptSensitive($row['Balance']) : 0.0;
        $decryptedReward   = !empty($row['Reward']) ? (float) decryptSensitive($row['Reward']) : 0.0;

        $users[] = [
            'id'                          => $row['id'],
            'Frist_Name'                  => $row['Frist_Name'],
            'Last_Name'                   => $row['Last_Name'],
            'Email'                       => $decryptedEmail,
            'Phone_number'                => $decryptedPhone,
            'PIN'                         => $decryptedPIN,
            'User_Password'               => $decryptedPassword,
            'Balance'                     => number_format($decryptedBalance, 2, '.', ''),
            'My_Reffer_Code'              => $row['My_Reffer_Code'],
            'Who_invite_reffer_code'      => $row['Who_invite_reffer_code'],
            'Joining_date'                => $row['Joining_date'],
            'Veryfi_Status'               => $row['Veryfi_Status'],
            'Total_Deposit'               => $row['Total_Deposit'],
            'Total_Spend'                 => $row['Total_Spend'],
            'FCM_Token'                   => $row['FCM_Token'],
            'Selfi_photo'                 => $row['Selfi_photo'],
            'Nid_Front'                   => $row['Nid_Front'],
            'Nid_Back'                    => $row['Nid_Back'],
            'Block'                       => $row['Block'],
            'Device_login'                => $row['Device_login'],
            'Reward'                      => number_format($decryptedReward, 2, '.', ''),
            'Ban_From_Add_money'          => $row['Ban_From_Add_money']
        ];
    }

    echo json_encode([
        "status" => "success",
        "data"   => $users
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status"  => "error",
        "message" => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>